/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xwing;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.generators.X25519KeyPairGenerator;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.X25519KeyGenerationParameters;
import org.bouncycastle.crypto.params.X25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMGenerator;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMPublicKeyParameters;
import org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import org.bouncycastle.pqc.crypto.xwing.XWingPublicKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class XWingKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom random;
    private static final byte[] XWING_LABEL = Strings.toByteArray("\\.//^\\");

    public XWingKEMGenerator(SecureRandom random) {
        this.random = random;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        XWingPublicKeyParameters key = (XWingPublicKeyParameters)recipientKey;
        MLKEMPublicKeyParameters kyberPub = key.getKyberPublicKey();
        X25519PublicKeyParameters xdhPub = key.getXDHPublicKey();
        byte[] xdhPubBytes = xdhPub.getEncoded();
        MLKEMGenerator mlkemGen = new MLKEMGenerator(this.random);
        SecretWithEncapsulation mlkemSec = mlkemGen.generateEncapsulated(kyberPub);
        byte[] ctM = mlkemSec.getEncapsulation();
        X25519KeyPairGenerator xdhGen = new X25519KeyPairGenerator();
        xdhGen.init(new X25519KeyGenerationParameters(this.random));
        AsymmetricCipherKeyPair ephXdhKp = xdhGen.generateKeyPair();
        byte[] ctX = ((X25519PublicKeyParameters)ephXdhKp.getPublic()).getEncoded();
        byte[] ssX = XWingKEMGenerator.computeSSX(xdhPub, (X25519PrivateKeyParameters)ephXdhKp.getPrivate());
        byte[] ss = XWingKEMGenerator.computeSharedSecret(xdhPubBytes, mlkemSec.getSecret(), ctX, ssX);
        Arrays.clear(ssX);
        return new SecretWithEncapsulationImpl(ss, Arrays.concatenate(ctM, ctX));
    }

    static byte[] computeSSX(X25519PublicKeyParameters xdhPub, X25519PrivateKeyParameters ephXdhPriv) {
        X25519Agreement xdhAgreement = new X25519Agreement();
        xdhAgreement.init(ephXdhPriv);
        byte[] ssX = new byte[xdhAgreement.getAgreementSize()];
        xdhAgreement.calculateAgreement(xdhPub, ssX, 0);
        return ssX;
    }

    static byte[] computeSharedSecret(byte[] xdhPubBytes, byte[] ssM, byte[] ctX, byte[] ssX) {
        SHA3Digest sha3 = new SHA3Digest(256);
        sha3.update(ssM, 0, ssM.length);
        sha3.update(ssX, 0, ssX.length);
        sha3.update(ctX, 0, ctX.length);
        sha3.update(xdhPubBytes, 0, xdhPubBytes.length);
        sha3.update(XWING_LABEL, 0, XWING_LABEL.length);
        byte[] ss = new byte[32];
        sha3.doFinal(ss, 0);
        return ss;
    }
}

