/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.slhdsa;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;
import org.bouncycastle.crypto.params.ParametersWithContext;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.DigestUtils;
import org.bouncycastle.pqc.crypto.slhdsa.ADRS;
import org.bouncycastle.pqc.crypto.slhdsa.Fors;
import org.bouncycastle.pqc.crypto.slhdsa.HT;
import org.bouncycastle.pqc.crypto.slhdsa.IndexedDigest;
import org.bouncycastle.pqc.crypto.slhdsa.SIG;
import org.bouncycastle.pqc.crypto.slhdsa.SIG_FORS;
import org.bouncycastle.pqc.crypto.slhdsa.SIG_XMSS;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAEngine;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.slhdsa.SLHDSAPublicKeyParameters;
import org.bouncycastle.util.Arrays;

public class HashSLHDSASigner
implements Signer {
    private byte[] msgPrefix;
    private SLHDSAPublicKeyParameters pubKey;
    private SLHDSAPrivateKeyParameters privKey;
    private SecureRandom random;
    private Digest digest;

    public void init(boolean forSigning, CipherParameters param) {
        SLHDSAParameters parameters;
        ParametersWithContext withContext = null;
        if (param instanceof ParametersWithContext) {
            withContext = (ParametersWithContext)param;
            param = ((ParametersWithContext)param).getParameters();
            if (withContext.getContextLength() > 255) {
                throw new IllegalArgumentException("context too long");
            }
        }
        if (forSigning) {
            this.pubKey = null;
            if (param instanceof ParametersWithRandom) {
                this.privKey = (SLHDSAPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
                this.random = ((ParametersWithRandom)param).getRandom();
            } else {
                this.privKey = (SLHDSAPrivateKeyParameters)param;
                this.random = null;
            }
            parameters = this.privKey.getParameters();
        } else {
            this.pubKey = (SLHDSAPublicKeyParameters)param;
            this.privKey = null;
            this.random = null;
            parameters = this.pubKey.getParameters();
        }
        this.initDigest(parameters, withContext);
    }

    private void initDigest(SLHDSAParameters parameters, ParametersWithContext withContext) {
        byte[] digestOIDEncoding;
        this.digest = HashSLHDSASigner.createDigest(parameters);
        ASN1ObjectIdentifier digestOID = DigestUtils.getDigestOid(this.digest.getAlgorithmName());
        try {
            digestOIDEncoding = digestOID.getEncoded("DER");
        }
        catch (IOException e) {
            throw new IllegalStateException("oid encoding failed: " + e.getMessage());
        }
        int ctxLength = withContext == null ? 0 : withContext.getContextLength();
        this.msgPrefix = new byte[2 + ctxLength + digestOIDEncoding.length];
        this.msgPrefix[0] = 1;
        this.msgPrefix[1] = (byte)ctxLength;
        if (withContext != null) {
            withContext.copyContextTo(this.msgPrefix, 2, ctxLength);
        }
        System.arraycopy(digestOIDEncoding, 0, this.msgPrefix, 2 + ctxLength, digestOIDEncoding.length);
    }

    public void update(byte b) {
        this.digest.update(b);
    }

    public void update(byte[] in, int off, int len) {
        this.digest.update(in, off, len);
    }

    public byte[] generateSignature() throws CryptoException, DataLengthException {
        SLHDSAEngine engine = this.privKey.getParameters().getEngine();
        engine.init(this.privKey.pk.seed);
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        byte[] optRand = new byte[engine.N];
        if (this.random != null) {
            this.random.nextBytes(optRand);
        } else {
            System.arraycopy(this.privKey.pk.seed, 0, optRand, 0, optRand.length);
        }
        return HashSLHDSASigner.internalGenerateSignature(this.privKey, this.msgPrefix, hash, optRand);
    }

    public boolean verifySignature(byte[] signature) {
        byte[] hash = new byte[this.digest.getDigestSize()];
        this.digest.doFinal(hash, 0);
        return HashSLHDSASigner.internalVerifySignature(this.pubKey, this.msgPrefix, hash, signature);
    }

    public void reset() {
        this.digest.reset();
    }

    protected byte[] internalGenerateSignature(byte[] message, byte[] optRand) {
        return HashSLHDSASigner.internalGenerateSignature(this.privKey, null, message, optRand);
    }

    private static byte[] internalGenerateSignature(SLHDSAPrivateKeyParameters privKey, byte[] msgPrefix, byte[] msg, byte[] optRand) {
        SLHDSAEngine engine = privKey.getParameters().getEngine();
        engine.init(privKey.pk.seed);
        Fors fors = new Fors(engine);
        byte[] R = engine.PRF_msg(privKey.sk.prf, optRand, msgPrefix, msg);
        IndexedDigest idxDigest = engine.H_msg(R, privKey.pk.seed, privKey.pk.root, msgPrefix, msg);
        byte[] mHash = idxDigest.digest;
        long idx_tree = idxDigest.idx_tree;
        int idx_leaf = idxDigest.idx_leaf;
        ADRS adrs = new ADRS();
        adrs.setTypeAndClear(3);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        SIG_FORS[] sig_fors = fors.sign(mHash, privKey.sk.seed, privKey.pk.seed, adrs);
        adrs = new ADRS();
        adrs.setTypeAndClear(3);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        byte[] PK_FORS = fors.pkFromSig(sig_fors, mHash, privKey.pk.seed, adrs);
        ADRS treeAdrs = new ADRS();
        treeAdrs.setTypeAndClear(2);
        HT ht = new HT(engine, privKey.getSeed(), privKey.getPublicSeed());
        byte[] SIG_HT = ht.sign(PK_FORS, idx_tree, idx_leaf);
        byte[][] sigComponents = new byte[sig_fors.length + 2][];
        sigComponents[0] = R;
        for (int i = 0; i != sig_fors.length; ++i) {
            sigComponents[1 + i] = Arrays.concatenate(sig_fors[i].sk, Arrays.concatenate(sig_fors[i].authPath));
        }
        sigComponents[sigComponents.length - 1] = SIG_HT;
        return Arrays.concatenate(sigComponents);
    }

    protected boolean internalVerifySignature(byte[] message, byte[] signature) {
        return HashSLHDSASigner.internalVerifySignature(this.pubKey, null, message, signature);
    }

    private static boolean internalVerifySignature(SLHDSAPublicKeyParameters pubKey, byte[] msgPrefix, byte[] msg, byte[] signature) {
        SLHDSAEngine engine = pubKey.getParameters().getEngine();
        engine.init(pubKey.getSeed());
        ADRS adrs = new ADRS();
        if ((1 + engine.K * (1 + engine.A) + engine.H + engine.D * engine.WOTS_LEN) * engine.N != signature.length) {
            return false;
        }
        SIG sig = new SIG(engine.N, engine.K, engine.A, engine.D, engine.H_PRIME, engine.WOTS_LEN, signature);
        byte[] R = sig.getR();
        SIG_FORS[] sig_fors = sig.getSIG_FORS();
        SIG_XMSS[] SIG_HT = sig.getSIG_HT();
        IndexedDigest idxDigest = engine.H_msg(R, pubKey.getSeed(), pubKey.getRoot(), msgPrefix, msg);
        byte[] mHash = idxDigest.digest;
        long idx_tree = idxDigest.idx_tree;
        int idx_leaf = idxDigest.idx_leaf;
        adrs.setTypeAndClear(3);
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        byte[] PK_FORS = new Fors(engine).pkFromSig(sig_fors, mHash, pubKey.getSeed(), adrs);
        adrs.setTypeAndClear(2);
        adrs.setLayerAddress(0);
        adrs.setTreeAddress(idx_tree);
        adrs.setKeyPairAddress(idx_leaf);
        HT ht = new HT(engine, null, pubKey.getSeed());
        return ht.verify(PK_FORS, SIG_HT, pubKey.getSeed(), idx_tree, idx_leaf, pubKey.getRoot());
    }

    private static Digest createDigest(SLHDSAParameters parameters) {
        switch (parameters.getType()) {
            case 0: {
                String name = parameters.getName();
                if (name.startsWith("sha2")) {
                    if (SLHDSAParameters.sha2_128f == parameters || SLHDSAParameters.sha2_128s == parameters) {
                        return SHA256Digest.newInstance();
                    }
                    return new SHA512Digest();
                }
                if (SLHDSAParameters.shake_128f == parameters || SLHDSAParameters.shake_128s == parameters) {
                    return new SHAKEDigest(128);
                }
                return new SHAKEDigest(256);
            }
            case 1: {
                return SHA256Digest.newInstance();
            }
            case 2: {
                return new SHA512Digest();
            }
            case 3: {
                return new SHAKEDigest(128);
            }
            case 4: {
                return new SHAKEDigest(256);
            }
        }
        throw new IllegalArgumentException("unknown parameters type");
    }
}

