/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.ntru;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUOWCPA;
import org.bouncycastle.pqc.crypto.ntru.NTRUParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.NTRUPublicKeyParameters;
import org.bouncycastle.pqc.crypto.ntru.OWCPAKeyPair;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUParameterSet;
import org.bouncycastle.util.Arrays;

public class NTRUKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private NTRUKeyGenerationParameters params;
    private SecureRandom random;

    public void init(KeyGenerationParameters param) {
        this.params = (NTRUKeyGenerationParameters)param;
        this.random = param.getRandom();
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        NTRUParameters parameters = this.params.getParameters();
        NTRUParameterSet parameterSet = parameters.getParameterSet();
        byte[] seed = new byte[parameterSet.sampleFgBytes()];
        this.random.nextBytes(seed);
        NTRUOWCPA owcpa = new NTRUOWCPA(parameterSet);
        OWCPAKeyPair owcpaKeys = owcpa.keypair(seed);
        byte[] publicKey = owcpaKeys.publicKey;
        byte[] prfBytes = new byte[parameterSet.prfKeyBytes()];
        this.random.nextBytes(prfBytes);
        byte[] privateKey = Arrays.concatenate(owcpaKeys.privateKey, prfBytes);
        return new AsymmetricCipherKeyPair(new NTRUPublicKeyParameters(parameters, publicKey), new NTRUPrivateKeyParameters(parameters, privateKey));
    }
}

