/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.mlkem;

import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHAKEDigest;

abstract class Symmetric {
    final int xofBlockBytes;

    abstract void hash_h(byte[] var1, byte[] var2, int var3);

    abstract void hash_g(byte[] var1, byte[] var2);

    abstract void xofAbsorb(byte[] var1, byte var2, byte var3);

    abstract void xofSqueezeBlocks(byte[] var1, int var2, int var3);

    abstract void prf(byte[] var1, byte[] var2, byte var3);

    abstract void kdf(byte[] var1, byte[] var2);

    Symmetric(int blockBytes) {
        this.xofBlockBytes = blockBytes;
    }

    static class ShakeSymmetric
    extends Symmetric {
        private final SHAKEDigest xof = new SHAKEDigest(128);
        private final SHA3Digest sha3Digest512;
        private final SHA3Digest sha3Digest256;
        private final SHAKEDigest shakeDigest = new SHAKEDigest(256);

        ShakeSymmetric() {
            super(168);
            this.sha3Digest256 = new SHA3Digest(256);
            this.sha3Digest512 = new SHA3Digest(512);
        }

        void hash_h(byte[] out, byte[] in, int outOffset) {
            this.sha3Digest256.update(in, 0, in.length);
            this.sha3Digest256.doFinal(out, outOffset);
        }

        void hash_g(byte[] out, byte[] in) {
            this.sha3Digest512.update(in, 0, in.length);
            this.sha3Digest512.doFinal(out, 0);
        }

        void xofAbsorb(byte[] seed, byte a, byte b) {
            this.xof.reset();
            byte[] buf = new byte[seed.length + 2];
            System.arraycopy(seed, 0, buf, 0, seed.length);
            buf[seed.length] = a;
            buf[seed.length + 1] = b;
            this.xof.update(buf, 0, seed.length + 2);
        }

        void xofSqueezeBlocks(byte[] out, int outOffset, int outLen) {
            this.xof.doOutput(out, outOffset, outLen);
        }

        void prf(byte[] out, byte[] seed, byte nonce) {
            byte[] extSeed = new byte[seed.length + 1];
            System.arraycopy(seed, 0, extSeed, 0, seed.length);
            extSeed[seed.length] = nonce;
            this.shakeDigest.update(extSeed, 0, extSeed.length);
            this.shakeDigest.doFinal(out, 0, out.length);
        }

        void kdf(byte[] out, byte[] in) {
            this.shakeDigest.update(in, 0, in.length);
            this.shakeDigest.doFinal(out, 0, out.length);
        }
    }
}

