/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.crystals.dilithium;

import java.security.SecureRandom;
import org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import org.bouncycastle.crypto.AsymmetricCipherKeyPairGenerator;
import org.bouncycastle.crypto.KeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumEngine;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyGenerationParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumPublicKeyParameters;

public class DilithiumKeyPairGenerator
implements AsymmetricCipherKeyPairGenerator {
    private DilithiumParameters dilithiumParams;
    private SecureRandom random;

    private void initialize(KeyGenerationParameters param) {
        this.dilithiumParams = ((DilithiumKeyGenerationParameters)param).getParameters();
        this.random = param.getRandom();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        DilithiumEngine engine = this.dilithiumParams.getEngine(this.random);
        byte[][] keyPair = engine.generateKeyPair();
        DilithiumPublicKeyParameters pubKey = new DilithiumPublicKeyParameters(this.dilithiumParams, keyPair[0], keyPair[6]);
        DilithiumPrivateKeyParameters privKey = new DilithiumPrivateKeyParameters(this.dilithiumParams, keyPair[0], keyPair[1], keyPair[2], keyPair[3], keyPair[4], keyPair[5], keyPair[6]);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }

    public void init(KeyGenerationParameters param) {
        this.initialize(param);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }

    public AsymmetricCipherKeyPair internalGenerateKeyPair(byte[] seed) {
        DilithiumEngine engine = this.dilithiumParams.getEngine(this.random);
        byte[][] keyPair = engine.generateKeyPairInternal(seed);
        DilithiumPublicKeyParameters pubKey = new DilithiumPublicKeyParameters(this.dilithiumParams, keyPair[0], keyPair[6]);
        DilithiumPrivateKeyParameters privKey = new DilithiumPrivateKeyParameters(this.dilithiumParams, keyPair[0], keyPair[1], keyPair[2], keyPair[3], keyPair[4], keyPair[5], keyPair[6]);
        return new AsymmetricCipherKeyPair(pubKey, privKey);
    }
}

