/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.params;

import java.math.BigInteger;
import java.security.SecureRandom;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.SAKKEPublicKeyParameters;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.BigIntegers;

public class SAKKEPrivateKeyParameters
extends AsymmetricKeyParameter {
    private static final BigInteger qMinOne = SAKKEPublicKeyParameters.q.subtract(BigInteger.ONE);
    private final SAKKEPublicKeyParameters publicParams;
    private final BigInteger z;

    public SAKKEPrivateKeyParameters(BigInteger z, SAKKEPublicKeyParameters publicParams) {
        super(true);
        this.z = z;
        this.publicParams = publicParams;
        ECPoint computed_Z = publicParams.getPoint().multiply(z).normalize();
        if (!computed_Z.equals(publicParams.getZ())) {
            throw new IllegalStateException("public key and private key of SAKKE do not match");
        }
    }

    public SAKKEPrivateKeyParameters(SecureRandom random) {
        super(true);
        this.z = BigIntegers.createRandomInRange(BigIntegers.TWO, qMinOne, random);
        BigInteger identifier = BigIntegers.createRandomInRange(BigIntegers.TWO, qMinOne, random);
        this.publicParams = new SAKKEPublicKeyParameters(identifier, SAKKEPublicKeyParameters.P.multiply(this.z).normalize());
    }

    public SAKKEPublicKeyParameters getPublicParams() {
        return this.publicParams;
    }

    public BigInteger getMasterSecret() {
        return this.z;
    }
}

