/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.digests.BufferBaseDigest;
import org.bouncycastle.crypto.digests.ISAPDigest;
import org.bouncycastle.crypto.engines.AsconPermutationFriend;

abstract class AsconBaseDigest
extends BufferBaseDigest {
    AsconPermutationFriend.AsconPermutation p = AsconPermutationFriend.getAsconPermutation(ISAPDigest.Friend.getFriend(Friend.access$000()));
    protected int ASCON_PB_ROUNDS = 12;

    protected AsconBaseDigest() {
        super(BufferBaseDigest.ProcessingBufferType.Immediate, 8);
        this.DigestSize = 32;
    }

    protected abstract long pad(int var1);

    protected abstract long loadBytes(byte[] var1, int var2);

    protected abstract long loadBytes(byte[] var1, int var2, int var3);

    protected abstract void setBytes(long var1, byte[] var3, int var4);

    protected abstract void setBytes(long var1, byte[] var3, int var4, int var5);

    protected void processBytes(byte[] input, int inOff) {
        this.p.x0 ^= this.loadBytes(input, inOff);
        this.p.p(this.ASCON_PB_ROUNDS);
    }

    protected void finish(byte[] output, int outOff) {
        this.padAndAbsorb();
        this.squeeze(output, outOff, this.DigestSize);
    }

    protected void padAndAbsorb() {
        this.p.x0 ^= this.loadBytes(this.m_buf, 0, this.m_bufPos) ^ this.pad(this.m_bufPos);
        this.p.p(12);
    }

    protected void squeeze(byte[] output, int outOff, int len) {
        while (len > this.BlockSize) {
            this.setBytes(this.p.x0, output, outOff);
            this.p.p(this.ASCON_PB_ROUNDS);
            outOff += this.BlockSize;
            len -= this.BlockSize;
        }
        this.setBytes(this.p.x0, output, outOff, len);
    }

    protected int hash(byte[] output, int outOff, int outLen) {
        this.ensureSufficientOutputBuffer(output, outOff, outLen);
        this.padAndAbsorb();
        this.squeeze(output, outOff, outLen);
        return outLen;
    }

    protected void ensureSufficientOutputBuffer(byte[] output, int outOff, int len) {
        if (outOff + len > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
    }

    public static class Friend {
        private static final Friend INSTANCE = new Friend();

        private Friend() {
        }

        static /* synthetic */ Friend access$000() {
            return INSTANCE;
        }
    }
}

