/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.xwing;

import org.bouncycastle.crypto.EncapsulatedSecretExtractor;
import org.bouncycastle.crypto.agreement.X25519Agreement;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.params.X25519PublicKeyParameters;
import org.bouncycastle.pqc.crypto.mlkem.MLKEMExtractor;
import org.bouncycastle.pqc.crypto.xwing.XWingPrivateKeyParameters;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class XWingKEMExtractor
implements EncapsulatedSecretExtractor {
    private final XWingPrivateKeyParameters key;
    private final MLKEMExtractor kemExtractor;

    public XWingKEMExtractor(XWingPrivateKeyParameters privParams) {
        this.key = privParams;
        this.kemExtractor = new MLKEMExtractor(this.key.getKyberPrivateKey());
    }

    public byte[] extractSecret(byte[] encapsulation) {
        byte[] kybSecret = this.kemExtractor.extractSecret(Arrays.copyOfRange(encapsulation, 0, encapsulation.length - 32));
        X25519Agreement xdhAgree = new X25519Agreement();
        byte[] k = new byte[kybSecret.length + xdhAgree.getAgreementSize()];
        System.arraycopy(kybSecret, 0, k, 0, kybSecret.length);
        Arrays.clear(kybSecret);
        xdhAgree.init(this.key.getXDHPrivateKey());
        X25519PublicKeyParameters ephXdhPub = new X25519PublicKeyParameters(Arrays.copyOfRange(encapsulation, encapsulation.length - 32, encapsulation.length));
        xdhAgree.calculateAgreement(ephXdhPub, k, kybSecret.length);
        SHA3Digest sha3 = new SHA3Digest(256);
        sha3.update(Strings.toByteArray("\\.//^\\"), 0, 6);
        sha3.update(k, 0, k.length);
        sha3.update(ephXdhPub.getEncoded(), 0, 32);
        sha3.update(this.key.getXDHPrivateKey().generatePublicKey().getEncoded(), 0, 32);
        byte[] kemSecret = new byte[32];
        sha3.doFinal(kemSecret, 0);
        return kemSecret;
    }

    public int getEncapsulationLength() {
        return this.kemExtractor.getEncapsulationLength() + 32;
    }
}

