/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.engines.AEADBaseEngine;
import org.bouncycastle.util.Arrays;

abstract class AEADBufferBaseEngine
extends AEADBaseEngine {
    protected static final int UNINITIALIZED = 0;
    protected static final int ENCINIT = 1;
    protected static final int ENCAAD = 2;
    protected static final int ENCDATA = 3;
    protected static final int ENCFINAL = 4;
    protected static final int DECINIT = 5;
    protected static final int DECAAD = 6;
    protected static final int DECDATA = 7;
    protected static final int DECFINAL = 8;
    protected static final State Uninitialized = new State(0);
    protected static final State EncInit = new State(1);
    protected static final State EncAad = new State(2);
    protected static final State EncData = new State(3);
    protected static final State EncFinal = new State(4);
    protected static final State DecInit = new State(5);
    protected static final State DecAad = new State(6);
    protected static final State DecData = new State(7);
    protected static final State DecFinal = new State(8);
    protected byte[] m_buf;
    protected byte[] m_aad;
    protected int m_bufPos;
    protected int m_aadPos;
    protected boolean aadFinished;
    protected boolean initialised = false;
    protected int AADBufferSize;
    protected int BlockSize;
    protected State m_state = Uninitialized;

    AEADBufferBaseEngine() {
    }

    public void processAADByte(byte input) {
        this.checkAAD();
        if (this.m_aadPos == this.AADBufferSize) {
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        this.m_aad[this.m_aadPos++] = input;
    }

    public void processAADBytes(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAAD();
        if (this.m_aadPos > 0) {
            int available = this.AADBufferSize - this.m_aadPos;
            if (len <= available) {
                System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, len);
                this.m_aadPos += len;
                return;
            }
            System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, available);
            inOff += available;
            len -= available;
            this.processBufferAAD(this.m_aad, 0);
            this.m_aadPos = 0;
        }
        while (len > this.AADBufferSize) {
            this.processBufferAAD(input, inOff);
            inOff += this.AADBufferSize;
            len -= this.AADBufferSize;
        }
        System.arraycopy(input, inOff, this.m_aad, this.m_aadPos, len);
        this.m_aadPos += len;
    }

    public int processBytes(byte[] input, int inOff, int len, byte[] output, int outOff) throws DataLengthException {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean forEncryption = this.checkData();
        int resultLength = 0;
        if (forEncryption) {
            if (this.m_bufPos > 0) {
                int available = this.BlockSize - this.m_bufPos;
                if (len <= available) {
                    System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return 0;
                }
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.validateAndProcessBuffer(this.m_buf, 0, output, outOff);
                resultLength = this.BlockSize;
            }
            while (len > this.BlockSize) {
                this.validateAndProcessBuffer(input, inOff, output, outOff + resultLength);
                inOff += this.BlockSize;
                len -= this.BlockSize;
                resultLength += this.BlockSize;
            }
        } else {
            int available = this.BlockSize + this.MAC_SIZE - this.m_bufPos;
            if (len <= available) {
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return 0;
            }
            if (this.BlockSize >= this.MAC_SIZE) {
                if (this.m_bufPos > this.BlockSize) {
                    this.validateAndProcessBuffer(this.m_buf, 0, output, outOff);
                    this.m_bufPos -= this.BlockSize;
                    System.arraycopy(this.m_buf, this.BlockSize, this.m_buf, 0, this.m_bufPos);
                    resultLength = this.BlockSize;
                    if (len <= (available += this.BlockSize)) {
                        System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                        this.m_bufPos += len;
                        return resultLength;
                    }
                }
                available = this.BlockSize - this.m_bufPos;
                System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.validateAndProcessBuffer(this.m_buf, 0, output, outOff + resultLength);
                resultLength += this.BlockSize;
            } else {
                while (this.m_bufPos > this.BlockSize && len + this.m_bufPos > this.BlockSize + this.MAC_SIZE) {
                    this.validateAndProcessBuffer(this.m_buf, resultLength, output, outOff + resultLength);
                    this.m_bufPos -= this.BlockSize;
                    resultLength += this.BlockSize;
                }
                if (this.m_bufPos != 0) {
                    System.arraycopy(this.m_buf, resultLength, this.m_buf, 0, this.m_bufPos);
                    if (this.m_bufPos + len > this.BlockSize + this.MAC_SIZE) {
                        available = Math.max(this.BlockSize - this.m_bufPos, 0);
                        System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, available);
                        inOff += available;
                        this.validateAndProcessBuffer(this.m_buf, 0, output, outOff + resultLength);
                        resultLength += this.BlockSize;
                        len -= available;
                    } else {
                        System.arraycopy(input, inOff, this.m_buf, this.m_bufPos, len);
                        this.m_bufPos += len;
                        return resultLength;
                    }
                }
            }
            while (len > this.BlockSize + this.MAC_SIZE) {
                this.validateAndProcessBuffer(input, inOff, output, outOff + resultLength);
                inOff += this.BlockSize;
                len -= this.BlockSize;
                resultLength += this.BlockSize;
            }
        }
        System.arraycopy(input, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    public int doFinal(byte[] output, int outOff) throws IllegalStateException, InvalidCipherTextException {
        int resultLength;
        boolean forEncryption = this.checkData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.MAC_SIZE;
        } else {
            if (this.m_bufPos < this.MAC_SIZE) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.MAC_SIZE;
            resultLength = this.m_bufPos;
        }
        if (outOff > output.length - resultLength) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processFinalBlock(output, outOff);
        if (forEncryption) {
            System.arraycopy(this.mac, 0, output, outOff + resultLength - this.MAC_SIZE, this.MAC_SIZE);
        } else if (!Arrays.constantTimeAreEqual(this.MAC_SIZE, this.mac, 0, this.m_buf, this.m_bufPos)) {
            throw new InvalidCipherTextException(this.algorithmName + " mac does not match");
        }
        this.reset(!forEncryption);
        return resultLength;
    }

    public int getBlockSize() {
        return this.BlockSize;
    }

    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len) - 1;
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                total = Math.max(0, total - this.MAC_SIZE);
                break;
            }
            case 7: 
            case 8: {
                total = Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
                break;
            }
            case 3: 
            case 4: {
                total = Math.max(0, total + this.m_bufPos);
                break;
            }
        }
        return total - total % this.BlockSize;
    }

    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                return Math.max(0, total - this.MAC_SIZE);
            }
            case 7: 
            case 8: {
                return Math.max(0, total + this.m_bufPos - this.MAC_SIZE);
            }
            case 3: 
            case 4: {
                return total + this.m_bufPos + this.MAC_SIZE;
            }
        }
        return total + this.MAC_SIZE;
    }

    protected void checkAAD() {
        switch (this.m_state.ord) {
            case 5: {
                this.m_state = DecAad;
                break;
            }
            case 1: {
                this.m_state = EncAad;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected boolean checkData() {
        switch (this.m_state.ord) {
            case 5: 
            case 6: {
                this.finishAAD(DecData);
                return false;
            }
            case 1: 
            case 2: {
                this.finishAAD(EncData);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalStateException(this.getAlgorithmName() + " cannot be reused for encryption");
            }
        }
        throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
    }

    private void finishAAD(State nextState) {
        switch (this.m_state.ord) {
            case 2: 
            case 6: {
                this.processFinalAAD();
                break;
            }
        }
        this.m_aadPos = 0;
        this.m_state = nextState;
    }

    protected void bufferReset() {
        Arrays.fill(this.m_buf, (byte)0);
        Arrays.fill(this.m_aad, (byte)0);
        this.m_bufPos = 0;
        this.m_aadPos = 0;
        switch (this.m_state.ord) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = DecInit;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = EncFinal;
                return;
            }
            default: {
                throw new IllegalStateException(this.getAlgorithmName() + " needs to be initialized");
            }
        }
    }

    protected void validateAndProcessBuffer(byte[] input, int inOff, byte[] output, int outOff) {
        if (outOff > output.length - this.BlockSize) {
            throw new OutputLengthException("output buffer too short");
        }
        this.processBuffer(input, inOff, output, outOff);
    }

    protected abstract void processFinalBlock(byte[] var1, int var2);

    protected abstract void processBufferAAD(byte[] var1, int var2);

    protected abstract void processFinalAAD();

    protected abstract void processBuffer(byte[] var1, int var2, byte[] var3, int var4);

    protected static class State {
        int ord;

        private State(int ord) {
            this.ord = ord;
        }
    }
}

