/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.digests;

import org.bouncycastle.crypto.Xof;
import org.bouncycastle.crypto.digests.AsconBaseDigest;
import org.bouncycastle.util.Pack;

public class AsconXof128
extends AsconBaseDigest
implements Xof {
    private boolean m_squeezing = false;

    public AsconXof128() {
        this.reset();
    }

    protected long pad(int i) {
        return 1L << (i << 3);
    }

    protected long loadBytes(byte[] bytes, int inOff) {
        return Pack.littleEndianToLong(bytes, inOff);
    }

    protected long loadBytes(byte[] bytes, int inOff, int n) {
        return Pack.littleEndianToLong(bytes, inOff, n);
    }

    protected void setBytes(long w, byte[] bytes, int inOff) {
        Pack.longToLittleEndian(w, bytes, inOff);
    }

    protected void setBytes(long w, byte[] bytes, int inOff, int n) {
        Pack.longToLittleEndian(w, bytes, inOff, n);
    }

    protected void padAndAbsorb() {
        this.m_squeezing = true;
        super.padAndAbsorb();
    }

    public String getAlgorithmName() {
        return "Ascon-XOF-128";
    }

    public void update(byte in) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(in);
    }

    public void update(byte[] input, int inOff, int len) {
        if (this.m_squeezing) {
            throw new IllegalArgumentException("attempt to absorb while squeezing");
        }
        super.update(input, inOff, len);
    }

    public int doOutput(byte[] output, int outOff, int outLen) {
        return this.hash(output, outOff, outLen);
    }

    public int doFinal(byte[] output, int outOff, int outLen) {
        int rlt = this.doOutput(output, outOff, outLen);
        this.reset();
        return rlt;
    }

    public int getByteLength() {
        return 8;
    }

    public void reset() {
        this.m_squeezing = false;
        super.reset();
        this.x0 = -2701369817892108309L;
        this.x1 = -3711838248891385495L;
        this.x2 = -1778763697082575311L;
        this.x3 = 1072114354614917324L;
        this.x4 = -2282070310009238562L;
    }
}

