/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.math.ntru;

import org.bouncycastle.pqc.math.ntru.HRSSPolynomial;
import org.bouncycastle.pqc.math.ntru.parameters.NTRUHRSSParameterSet;

public class HRSS1373Polynomial
extends HRSSPolynomial {
    private static final int L = 1376;
    private static final int M = 344;
    private static final int K = 86;

    public HRSS1373Polynomial(NTRUHRSSParameterSet params) {
        super(params);
    }

    public byte[] sqToBytes(int len) {
        byte[] r = new byte[len];
        short[] t = new short[4];
        for (int i = 0; i < this.params.packDegree() / 4; ++i) {
            for (int j = 0; j < 4; ++j) {
                t[j] = (short)HRSS1373Polynomial.modQ(this.coeffs[4 * i + j] & 0xFFFF, this.params.q());
            }
            r[7 * i + 0] = (byte)(t[0] & 0xFF);
            r[7 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 3) << 6);
            r[7 * i + 2] = (byte)(t[1] >>> 2 & 0xFF);
            r[7 * i + 3] = (byte)(t[1] >>> 10 | (t[2] & 0xF) << 4);
            r[7 * i + 4] = (byte)(t[2] >>> 4 & 0xFF);
            r[7 * i + 5] = (byte)(t[2] >>> 12 | (t[3] & 0x3F) << 2);
            r[7 * i + 6] = (byte)(t[3] >>> 6);
        }
        if (this.params.packDegree() % 4 == 2) {
            t[0] = (short)HRSS1373Polynomial.modQ(this.coeffs[this.params.packDegree() - 2] & 0xFFFF, this.params.q());
            t[1] = (short)HRSS1373Polynomial.modQ(this.coeffs[this.params.packDegree() - 1] & 0xFFFF, this.params.q());
            r[7 * i + 0] = (byte)(t[0] & 0xFF);
            r[7 * i + 1] = (byte)(t[0] >>> 8 | (t[1] & 3) << 6);
            r[7 * i + 2] = (byte)(t[1] >>> 2 & 0xFF);
            r[7 * i + 3] = (byte)(t[1] >>> 10);
        }
        return r;
    }

    public void sqFromBytes(byte[] a) {
        int i;
        for (i = 0; i < this.params.packDegree() / 4; ++i) {
            this.coeffs[4 * i + 0] = (short)(a[7 * i + 0] & 0xFF | ((short)(a[7 * i + 1] & 0xFF) & 0x3F) << 8);
            this.coeffs[4 * i + 1] = (short)((a[7 * i + 1] & 0xFF) >>> 6 | (short)(a[7 * i + 2] & 0xFF) << 2 | (short)(a[7 * i + 3] & 0xF) << 10);
            this.coeffs[4 * i + 2] = (short)((a[7 * i + 3] & 0xFF) >>> 4 | ((short)(a[7 * i + 4] & 0xFF) & 0xFF) << 4 | (short)(a[7 * i + 5] & 3) << 12);
            this.coeffs[4 * i + 3] = (short)((a[7 * i + 5] & 0xFF) >>> 2 | (short)(a[7 * i + 6] & 0xFF) << 6);
        }
        if (this.params.packDegree() % 4 == 2) {
            this.coeffs[4 * i + 0] = (short)(a[7 * i + 0] | (a[7 * i + 1] & 0x3F) << 8);
            this.coeffs[4 * i + 1] = (short)(a[7 * i + 1] >>> 6 | (short)a[7 * i + 2] << 2 | ((short)a[7 * i + 3] & 0xF) << 10);
        }
        this.coeffs[this.params.n() - 1] = 0;
    }
}

