/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import org.bouncycastle.crypto.engines.Utils;
import org.bouncycastle.crypto.modes.AEADCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AsconEngine
implements AEADCipher {
    static final int Uninitialized = 0;
    static final int EncInit = 1;
    static final int EncAad = 2;
    static final int EncData = 3;
    static final int EncFinal = 4;
    static final int DecInit = 5;
    static final int DecAad = 6;
    static final int DecData = 7;
    static final int DecFinal = 8;
    private final AsconParameters asconParameters;
    private int m_state = 0;
    private byte[] mac;
    private byte[] initialAssociatedText;
    private final String algorithmName;
    private final int CRYPTO_KEYBYTES;
    private final int CRYPTO_ABYTES;
    private final int ASCON_AEAD_RATE;
    private final int nr;
    private long K0;
    private long K1;
    private long K2;
    private long N0;
    private long N1;
    private final long ASCON_IV;
    private long x0;
    private long x1;
    private long x2;
    private long x3;
    private long x4;
    private final int m_bufferSizeDecrypt;
    private final byte[] m_buf;
    private int m_bufPos = 0;

    public AsconEngine(AsconParameters asconParameters) {
        this.asconParameters = asconParameters;
        switch (asconParameters.ord) {
            case 0: {
                this.CRYPTO_KEYBYTES = 20;
                this.CRYPTO_ABYTES = 16;
                this.ASCON_AEAD_RATE = 8;
                this.ASCON_IV = -6899501409222262784L;
                this.algorithmName = "Ascon-80pq AEAD";
                break;
            }
            case 1: {
                this.CRYPTO_KEYBYTES = 16;
                this.CRYPTO_ABYTES = 16;
                this.ASCON_AEAD_RATE = 16;
                this.ASCON_IV = -9187330011336540160L;
                this.algorithmName = "Ascon-128a AEAD";
                break;
            }
            case 2: {
                this.CRYPTO_KEYBYTES = 16;
                this.CRYPTO_ABYTES = 16;
                this.ASCON_AEAD_RATE = 8;
                this.ASCON_IV = -9205344418435956736L;
                this.algorithmName = "Ascon-128 AEAD";
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid parameter setting for ASCON AEAD");
            }
        }
        this.nr = this.ASCON_AEAD_RATE == 8 ? 6 : 8;
        this.m_bufferSizeDecrypt = this.ASCON_AEAD_RATE + this.CRYPTO_ABYTES;
        this.m_buf = new byte[this.m_bufferSizeDecrypt];
    }

    private long ROR(long x, int n) {
        return x >>> n | x << 64 - n;
    }

    private long PAD(int i) {
        return 128L << 56 - (i << 3);
    }

    private void ROUND(long C) {
        long t0 = this.x0 ^ this.x1 ^ this.x2 ^ this.x3 ^ C ^ this.x1 & (this.x0 ^ this.x2 ^ this.x4 ^ C);
        long t1 = this.x0 ^ this.x2 ^ this.x3 ^ this.x4 ^ C ^ (this.x1 ^ this.x2 ^ C) & (this.x1 ^ this.x3);
        long t2 = this.x1 ^ this.x2 ^ this.x4 ^ C ^ this.x3 & this.x4;
        long t3 = this.x0 ^ this.x1 ^ this.x2 ^ C ^ (this.x0 ^ 0xFFFFFFFFFFFFFFFFL) & (this.x3 ^ this.x4);
        long t4 = this.x1 ^ this.x3 ^ this.x4 ^ (this.x0 ^ this.x4) & this.x1;
        this.x0 = t0 ^ this.ROR(t0, 19) ^ this.ROR(t0, 28);
        this.x1 = t1 ^ this.ROR(t1, 39) ^ this.ROR(t1, 61);
        this.x2 = t2 ^ this.ROR(t2, 1) ^ this.ROR(t2, 6) ^ 0xFFFFFFFFFFFFFFFFL;
        this.x3 = t3 ^ this.ROR(t3, 10) ^ this.ROR(t3, 17);
        this.x4 = t4 ^ this.ROR(t4, 7) ^ this.ROR(t4, 41);
    }

    private void P(int nr) {
        if (nr == 12) {
            this.ROUND(240L);
            this.ROUND(225L);
            this.ROUND(210L);
            this.ROUND(195L);
        }
        if (nr >= 8) {
            this.ROUND(180L);
            this.ROUND(165L);
        }
        this.ROUND(150L);
        this.ROUND(135L);
        this.ROUND(120L);
        this.ROUND(105L);
        this.ROUND(90L);
        this.ROUND(75L);
    }

    private void ascon_aeadinit() {
        this.x0 = this.ASCON_IV;
        if (this.CRYPTO_KEYBYTES == 20) {
            this.x0 ^= this.K0;
        }
        this.x1 = this.K1;
        this.x2 = this.K2;
        this.x3 = this.N0;
        this.x4 = this.N1;
        this.P(12);
        if (this.CRYPTO_KEYBYTES == 20) {
            this.x2 ^= this.K0;
        }
        this.x3 ^= this.K1;
        this.x4 ^= this.K2;
    }

    private void checkAad() {
        switch (this.m_state) {
            case 5: {
                this.m_state = 6;
                break;
            }
            case 1: {
                this.m_state = 2;
                break;
            }
            case 2: 
            case 6: {
                break;
            }
            case 4: {
                throw new IllegalArgumentException(this.algorithmName + " cannot be reused for encryption");
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
    }

    private boolean CheckData() {
        switch (this.m_state) {
            case 5: 
            case 6: {
                this.FinishAad(7);
                return false;
            }
            case 1: 
            case 2: {
                this.FinishAad(3);
                return true;
            }
            case 7: {
                return false;
            }
            case 3: {
                return true;
            }
            case 4: {
                throw new IllegalArgumentException(this.algorithmName + " cannot be reused for encryption");
            }
        }
        throw new IllegalArgumentException();
    }

    private void ProcessBufferAad(byte[] buffer, int inOff) {
        this.x0 ^= Pack.bigEndianToLong(buffer, inOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= Pack.bigEndianToLong(buffer, 8 + inOff);
        }
        this.P(this.nr);
    }

    private void FinishAad(int nextState) {
        switch (this.m_state) {
            case 2: 
            case 6: {
                this.m_buf[this.m_bufPos] = -128;
                if (this.m_bufPos >= 8) {
                    this.x0 ^= Pack.bigEndianToLong(this.m_buf, 0);
                    this.x1 ^= Pack.bigEndianToLong(this.m_buf, 8) & -1L << 56 - (this.m_bufPos - 8 << 3);
                } else {
                    this.x0 ^= Pack.bigEndianToLong(this.m_buf, 0) & -1L << 56 - (this.m_bufPos << 3);
                }
                this.P(this.nr);
            }
        }
        this.x4 ^= 1L;
        this.m_bufPos = 0;
        this.m_state = nextState;
    }

    private void ProcessBufferDecrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException(this.algorithmName + " output buffer too short");
        }
        long t0 = Pack.bigEndianToLong(buffer, bufOff);
        Pack.longToBigEndian(this.x0 ^ t0, output, outOff);
        this.x0 = t0;
        if (this.ASCON_AEAD_RATE == 16) {
            long t1 = Pack.bigEndianToLong(buffer, bufOff + 8);
            Pack.longToBigEndian(this.x1 ^ t1, output, outOff + 8);
            this.x1 = t1;
        }
        this.P(this.nr);
    }

    private void ProcessBufferEncrypt(byte[] buffer, int bufOff, byte[] output, int outOff) {
        if (outOff + this.ASCON_AEAD_RATE > output.length) {
            throw new OutputLengthException(this.algorithmName + " output buffer too short");
        }
        this.x0 ^= Pack.bigEndianToLong(buffer, bufOff);
        Pack.longToBigEndian(this.x0, output, outOff);
        if (this.ASCON_AEAD_RATE == 16) {
            this.x1 ^= Pack.bigEndianToLong(buffer, bufOff + 8);
            Pack.longToBigEndian(this.x1, output, outOff + 8);
        }
        this.P(this.nr);
    }

    private void ProcessFinalDecrypt(byte[] input, int inOff, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            long c0 = Pack.bigEndianToLong(input, inOff);
            this.x0 ^= c0;
            Pack.longToBigEndian(this.x0, output, outOff);
            this.x0 = c0;
            inOff += 8;
            outOff += 8;
            this.x1 ^= this.PAD(inLen -= 8);
            if (inLen != 0) {
                long c1 = Pack.littleEndianToLong_High(input, inOff, inLen);
                this.x1 ^= c1;
                Pack.longToLittleEndian_High(this.x1, output, outOff, inLen);
                this.x1 &= -1L >>> (inLen << 3);
                this.x1 ^= c1;
            }
        } else {
            this.x0 ^= this.PAD(inLen);
            if (inLen != 0) {
                long c0 = Pack.littleEndianToLong_High(input, inOff, inLen);
                this.x0 ^= c0;
                Pack.longToLittleEndian_High(this.x0, output, outOff, inLen);
                this.x0 &= -1L >>> (inLen << 3);
                this.x0 ^= c0;
            }
        }
        this.FinishData(8);
    }

    private void ProcessFinalEncrypt(byte[] input, int inOff, int inLen, byte[] output, int outOff) {
        if (inLen >= 8) {
            this.x0 ^= Pack.bigEndianToLong(input, inOff);
            Pack.longToBigEndian(this.x0, output, outOff);
            inOff += 8;
            outOff += 8;
            this.x1 ^= this.PAD(inLen -= 8);
            if (inLen != 0) {
                this.x1 ^= Pack.littleEndianToLong_High(input, inOff, inLen);
                Pack.longToLittleEndian_High(this.x1, output, outOff, inLen);
            }
        } else {
            this.x0 ^= this.PAD(inLen);
            if (inLen != 0) {
                this.x0 ^= Pack.littleEndianToLong_High(input, inOff, inLen);
                Pack.longToLittleEndian_High(this.x0, output, outOff, inLen);
            }
        }
        this.FinishData(4);
    }

    private void FinishData(int nextState) {
        switch (this.asconParameters.ord) {
            case 2: {
                this.x1 ^= this.K1;
                this.x2 ^= this.K2;
                break;
            }
            case 1: {
                this.x2 ^= this.K1;
                this.x3 ^= this.K2;
                break;
            }
            case 0: {
                this.x1 ^= this.K0 << 32 | this.K1 >> 32;
                this.x2 ^= this.K1 << 32 | this.K2 >> 32;
                this.x3 ^= this.K2 << 32;
                break;
            }
        }
        this.P(12);
        this.x3 ^= this.K1;
        this.x4 ^= this.K2;
        this.m_state = nextState;
    }

    /*
     * WARNING - void declaration
     */
    public void init(boolean forEncryption, CipherParameters params) throws IllegalArgumentException {
        void var4_5;
        void var3_4;
        byte[] npub;
        KeyParameter key;
        if (params instanceof AEADParameters) {
            AEADParameters aeadParameters = (AEADParameters)params;
            key = aeadParameters.getKey();
            npub = aeadParameters.getNonce();
            this.initialAssociatedText = aeadParameters.getAssociatedText();
            int macSizeBits = aeadParameters.getMacSize();
            if (macSizeBits != this.CRYPTO_ABYTES * 8) {
                throw new IllegalArgumentException("Invalid value for MAC size: " + macSizeBits);
            }
        } else if (params instanceof ParametersWithIV) {
            ParametersWithIV withIV = (ParametersWithIV)params;
            key = (KeyParameter)withIV.getParameters();
            npub = withIV.getIV();
            this.initialAssociatedText = null;
        } else {
            throw new IllegalArgumentException("invalid parameters passed to Ascon");
        }
        if (var3_4 == null) {
            throw new IllegalArgumentException("Ascon Init parameters must include a key");
        }
        if (var4_5 == null || ((void)var4_5).length != this.CRYPTO_ABYTES) {
            throw new IllegalArgumentException(this.asconParameters + " requires exactly " + this.CRYPTO_ABYTES + " bytes of IV");
        }
        byte[] k = var3_4.getKey();
        if (k.length != this.CRYPTO_KEYBYTES) {
            throw new IllegalArgumentException(this.asconParameters + " key must be " + this.CRYPTO_KEYBYTES + " bytes long");
        }
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties(this.getAlgorithmName(), 128, params, Utils.getPurpose(forEncryption)));
        this.N0 = Pack.bigEndianToLong((byte[])var4_5, 0);
        this.N1 = Pack.bigEndianToLong((byte[])var4_5, 8);
        if (this.CRYPTO_KEYBYTES == 16) {
            this.K1 = Pack.bigEndianToLong(k, 0);
            this.K2 = Pack.bigEndianToLong(k, 8);
        } else if (this.CRYPTO_KEYBYTES == 20) {
            this.K0 = Pack.bigEndianToInt(k, 0);
            this.K1 = Pack.bigEndianToLong(k, 4);
            this.K2 = Pack.bigEndianToLong(k, 12);
        }
        this.m_state = forEncryption ? 1 : 5;
        this.reset(true);
    }

    public String getAlgorithmName() {
        return this.algorithmName;
    }

    public String getAlgorithmVersion() {
        return "v1.2";
    }

    public void processAADByte(byte in) {
        this.checkAad();
        this.m_buf[this.m_bufPos] = in;
        if (++this.m_bufPos == this.ASCON_AEAD_RATE) {
            this.ProcessBufferAad(this.m_buf, 0);
        }
    }

    public void processAADBytes(byte[] inBytes, int inOff, int len) {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        if (len <= 0) {
            return;
        }
        this.checkAad();
        if (this.m_bufPos > 0) {
            int available = this.ASCON_AEAD_RATE - this.m_bufPos;
            if (len < available) {
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return;
            }
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.ProcessBufferAad(this.m_buf, 0);
        }
        while (len >= this.ASCON_AEAD_RATE) {
            this.ProcessBufferAad(inBytes, inOff);
            inOff += this.ASCON_AEAD_RATE;
            len -= this.ASCON_AEAD_RATE;
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
    }

    public int processByte(byte in, byte[] out, int outOff) throws DataLengthException {
        return this.processBytes(new byte[]{in}, 0, 1, out, outOff);
    }

    public int processBytes(byte[] inBytes, int inOff, int len, byte[] outBytes, int outOff) throws DataLengthException {
        if (inOff + len > inBytes.length) {
            throw new DataLengthException("input buffer too short");
        }
        boolean forEncryption = this.CheckData();
        int resultLength = 0;
        if (forEncryption) {
            if (this.m_bufPos > 0) {
                int available = this.ASCON_AEAD_RATE - this.m_bufPos;
                if (len < available) {
                    System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return 0;
                }
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
                inOff += available;
                len -= available;
                this.ProcessBufferEncrypt(this.m_buf, 0, outBytes, outOff);
                resultLength = this.ASCON_AEAD_RATE;
            }
            while (len >= this.ASCON_AEAD_RATE) {
                this.ProcessBufferEncrypt(inBytes, inOff, outBytes, outOff + resultLength);
                inOff += this.ASCON_AEAD_RATE;
                len -= this.ASCON_AEAD_RATE;
                resultLength += this.ASCON_AEAD_RATE;
            }
        } else {
            int available = this.m_bufferSizeDecrypt - this.m_bufPos;
            if (len < available) {
                System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                this.m_bufPos += len;
                return 0;
            }
            if (this.m_bufPos >= this.ASCON_AEAD_RATE) {
                this.ProcessBufferDecrypt(this.m_buf, 0, outBytes, outOff);
                this.m_bufPos -= this.ASCON_AEAD_RATE;
                System.arraycopy(this.m_buf, this.ASCON_AEAD_RATE, this.m_buf, 0, this.m_bufPos);
                resultLength = this.ASCON_AEAD_RATE;
                if (len < (available += this.ASCON_AEAD_RATE)) {
                    System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, len);
                    this.m_bufPos += len;
                    return resultLength;
                }
            }
            available = this.ASCON_AEAD_RATE - this.m_bufPos;
            System.arraycopy(inBytes, inOff, this.m_buf, this.m_bufPos, available);
            inOff += available;
            len -= available;
            this.ProcessBufferDecrypt(this.m_buf, 0, outBytes, outOff + resultLength);
            resultLength += this.ASCON_AEAD_RATE;
            while (len >= this.m_bufferSizeDecrypt) {
                this.ProcessBufferDecrypt(inBytes, inOff, outBytes, outOff + resultLength);
                inOff += this.ASCON_AEAD_RATE;
                len -= this.ASCON_AEAD_RATE;
                resultLength += this.ASCON_AEAD_RATE;
            }
        }
        System.arraycopy(inBytes, inOff, this.m_buf, 0, len);
        this.m_bufPos = len;
        return resultLength;
    }

    public int doFinal(byte[] outBytes, int outOff) throws IllegalStateException, InvalidCipherTextException, DataLengthException {
        int resultLength;
        boolean forEncryption = this.CheckData();
        if (forEncryption) {
            resultLength = this.m_bufPos + this.CRYPTO_ABYTES;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException(this.algorithmName + " output buffer too short");
            }
            this.ProcessFinalEncrypt(this.m_buf, 0, this.m_bufPos, outBytes, outOff);
            this.mac = new byte[this.CRYPTO_ABYTES];
            Pack.longToBigEndian(this.x3, this.mac, 0);
            Pack.longToBigEndian(this.x4, this.mac, 8);
            System.arraycopy(this.mac, 0, outBytes, outOff + this.m_bufPos, this.CRYPTO_ABYTES);
            this.reset(false);
        } else {
            if (this.m_bufPos < this.CRYPTO_ABYTES) {
                throw new InvalidCipherTextException("data too short");
            }
            this.m_bufPos -= this.CRYPTO_ABYTES;
            resultLength = this.m_bufPos;
            if (outOff + resultLength > outBytes.length) {
                throw new OutputLengthException(this.algorithmName + " output buffer too short");
            }
            this.ProcessFinalDecrypt(this.m_buf, 0, this.m_bufPos, outBytes, outOff);
            this.x3 ^= Pack.bigEndianToLong(this.m_buf, this.m_bufPos);
            this.x4 ^= Pack.bigEndianToLong(this.m_buf, this.m_bufPos + 8);
            if ((this.x3 | this.x4) != 0L) {
                throw new InvalidCipherTextException("mac check in " + this.algorithmName + " failed");
            }
            this.reset(true);
        }
        return resultLength;
    }

    public byte[] getMac() {
        return this.mac;
    }

    public int getUpdateOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case 5: 
            case 6: {
                total = Math.max(0, total - this.CRYPTO_ABYTES);
                break;
            }
            case 7: 
            case 8: {
                total = Math.max(0, total + this.m_bufPos - this.CRYPTO_ABYTES);
                break;
            }
            case 3: 
            case 4: {
                total += this.m_bufPos;
                break;
            }
        }
        return total - total % this.ASCON_AEAD_RATE;
    }

    public int getOutputSize(int len) {
        int total = Math.max(0, len);
        switch (this.m_state) {
            case 5: 
            case 6: {
                return Math.max(0, total - this.CRYPTO_ABYTES);
            }
            case 7: 
            case 8: {
                return Math.max(0, total + this.m_bufPos - this.CRYPTO_ABYTES);
            }
            case 3: 
            case 4: {
                return total + this.m_bufPos + this.CRYPTO_ABYTES;
            }
        }
        return total + this.CRYPTO_ABYTES;
    }

    public void reset() {
        this.reset(true);
    }

    private void reset(boolean clearMac) {
        if (clearMac) {
            this.mac = null;
        }
        Arrays.clear(this.m_buf);
        this.m_bufPos = 0;
        switch (this.m_state) {
            case 1: 
            case 5: {
                break;
            }
            case 6: 
            case 7: 
            case 8: {
                this.m_state = 5;
                break;
            }
            case 2: 
            case 3: 
            case 4: {
                this.m_state = 4;
                return;
            }
            default: {
                throw new IllegalArgumentException();
            }
        }
        this.ascon_aeadinit();
        if (this.initialAssociatedText != null) {
            this.processAADBytes(this.initialAssociatedText, 0, this.initialAssociatedText.length);
        }
    }

    public int getKeyBytesSize() {
        return this.CRYPTO_KEYBYTES;
    }

    public int getIVBytesSize() {
        return this.CRYPTO_ABYTES;
    }

    public static class AsconParameters {
        public static final AsconParameters ascon80pq = new AsconParameters(0);
        public static final AsconParameters ascon128a = new AsconParameters(1);
        public static final AsconParameters ascon128 = new AsconParameters(2);
        private final int ord;

        AsconParameters(int ord) {
            this.ord = ord;
        }
    }
}

