/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.crypto.qteslarnd1;

import java.security.SecureRandom;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.pqc.crypto.MessageSigner;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLA;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPrivateKeyParameters;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLAPublicKeyParameters;
import org.bouncycastle.pqc.crypto.qteslarnd1.QTESLASecurityCategory;

public class QTESLASigner
implements MessageSigner {
    private QTESLAPublicKeyParameters publicKey;
    private QTESLAPrivateKeyParameters privateKey;
    private SecureRandom secureRandom;

    public void init(boolean forSigning, CipherParameters param) {
        if (forSigning) {
            if (param instanceof ParametersWithRandom) {
                this.secureRandom = ((ParametersWithRandom)param).getRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)((ParametersWithRandom)param).getParameters();
            } else {
                this.secureRandom = CryptoServicesRegistrar.getSecureRandom();
                this.privateKey = (QTESLAPrivateKeyParameters)param;
            }
            this.publicKey = null;
            QTESLASecurityCategory.validate(this.privateKey.getSecurityCategory());
        } else {
            this.privateKey = null;
            this.publicKey = (QTESLAPublicKeyParameters)param;
            QTESLASecurityCategory.validate(this.publicKey.getSecurityCategory());
        }
    }

    public byte[] generateSignature(byte[] message) {
        byte[] sig = new byte[QTESLASecurityCategory.getSignatureSize(this.privateKey.getSecurityCategory())];
        switch (this.privateKey.getSecurityCategory()) {
            case 0: {
                QTESLA.signingI(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 1: {
                QTESLA.signingIIISize(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 2: {
                QTESLA.signingIIISpeed(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 3: {
                QTESLA.signingIP(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            case 4: {
                QTESLA.signingIIIP(sig, message, 0, message.length, this.privateKey.getSecret(), this.secureRandom);
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.privateKey.getSecurityCategory());
            }
        }
        return sig;
    }

    /*
     * WARNING - void declaration
     */
    public boolean verifySignature(byte[] message, byte[] signature) {
        void var3_3;
        switch (this.publicKey.getSecurityCategory()) {
            case 0: {
                int status = QTESLA.verifyingI(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 1: {
                int status = QTESLA.verifyingIIISize(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 2: {
                int status = QTESLA.verifyingIIISpeed(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 3: {
                int status = QTESLA.verifyingPI(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            case 4: {
                int status = QTESLA.verifyingPIII(message, signature, 0, signature.length, this.publicKey.getPublicData());
                break;
            }
            default: {
                throw new IllegalArgumentException("unknown security category: " + this.publicKey.getSecurityCategory());
            }
        }
        return false == var3_3;
    }
}

