/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.asn1.tsp;

import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DLSequence;

public class EncryptionInfo
extends ASN1Object {
    private ASN1ObjectIdentifier encryptionInfoType;
    private ASN1Encodable encryptionInfoValue;

    public static EncryptionInfo getInstance(ASN1Object obj) {
        if (obj instanceof EncryptionInfo) {
            return (EncryptionInfo)obj;
        }
        if (obj != null) {
            return new EncryptionInfo(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public static EncryptionInfo getInstance(ASN1TaggedObject obj, boolean explicit) {
        return EncryptionInfo.getInstance(ASN1Sequence.getInstance(obj, explicit));
    }

    private EncryptionInfo(ASN1Sequence sequence) {
        if (sequence.size() != 2) {
            throw new IllegalArgumentException("wrong sequence size in constructor: " + sequence.size());
        }
        this.encryptionInfoType = ASN1ObjectIdentifier.getInstance(sequence.getObjectAt(0));
        this.encryptionInfoValue = sequence.getObjectAt(1);
    }

    public EncryptionInfo(ASN1ObjectIdentifier encryptionInfoType, ASN1Encodable encryptionInfoValue) {
        this.encryptionInfoType = encryptionInfoType;
        this.encryptionInfoValue = encryptionInfoValue;
    }

    public ASN1Primitive toASN1Primitive() {
        ASN1EncodableVector v = new ASN1EncodableVector(2);
        v.add(this.encryptionInfoType);
        v.add(this.encryptionInfoValue);
        return new DLSequence(v);
    }
}

