/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import org.bouncycastle.asn1.bc.BCObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.pqc.addon.NHPublicKeyParameters;

class NHUtils {
    NHUtils() {
    }

    static byte[] getEncoded(NHPublicKeyParameters nHPublicKeyParameters) {
        try {
            AlgorithmIdentifier algorithmIdentifier = new AlgorithmIdentifier(BCObjectIdentifiers.newHope);
            SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(algorithmIdentifier, nHPublicKeyParameters.getPubData());
            return subjectPublicKeyInfo.getEncoded();
        }
        catch (IOException iOException) {
            return null;
        }
    }

    static NHPublicKeyParameters getPublicKey(byte[] byArray) {
        SubjectPublicKeyInfo subjectPublicKeyInfo = SubjectPublicKeyInfo.getInstance((Object)byArray);
        return new NHPublicKeyParameters(subjectPublicKeyInfo.getPublicKeyData().getOctets());
    }
}

