/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.crypto.SecretWithEncapsulation;
import org.bouncycastle.pqc.addon.AsymmetricKeyParameter;
import org.bouncycastle.pqc.addon.EncapsulatedSecretGenerator;
import org.bouncycastle.pqc.addon.FrodoEngine;
import org.bouncycastle.pqc.addon.FrodoPublicKeyParameters;
import org.bouncycastle.pqc.addon.SecretWithEncapsulationImpl;

class FrodoKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public FrodoKEMGenerator(SecureRandom secureRandom) {
        this.sr = secureRandom;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter asymmetricKeyParameter) {
        FrodoPublicKeyParameters frodoPublicKeyParameters = (FrodoPublicKeyParameters)asymmetricKeyParameter;
        FrodoEngine frodoEngine = frodoPublicKeyParameters.getParameters().getEngine();
        byte[] byArray = new byte[frodoEngine.getCipherTextSize()];
        byte[] byArray2 = new byte[frodoEngine.getSessionKeySize()];
        try {
            frodoEngine.kem_enc(byArray, byArray2, frodoPublicKeyParameters.getPublicKey(), this.sr);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("kem_enc failed!", iOException);
        }
        return new SecretWithEncapsulationImpl(byArray2, byArray);
    }
}

