/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import java.security.SecureRandom;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.CMCEEngine;
import org.bouncycastle.pqc.addon.CMCEKeyGenerationParameters;
import org.bouncycastle.pqc.addon.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.addon.CMCEPublicKeyParameters;

class CMCEKeyPairGenerator {
    private CMCEKeyGenerationParameters cmceParams;
    private int m;
    private int n;
    private int t;
    private SecureRandom random;

    CMCEKeyPairGenerator() {
    }

    private void initialize(CMCEKeyGenerationParameters cMCEKeyGenerationParameters) {
        this.cmceParams = cMCEKeyGenerationParameters;
        this.random = cMCEKeyGenerationParameters.getRandom();
        this.m = this.cmceParams.getParameters().getM();
        this.n = this.cmceParams.getParameters().getN();
        this.t = this.cmceParams.getParameters().getT();
    }

    private AsymmetricCipherKeyPair genKeyPair() {
        CMCEEngine cMCEEngine = this.cmceParams.getParameters().getEngine();
        byte[] byArray = new byte[cMCEEngine.getPrivateKeySize()];
        byte[] byArray2 = new byte[cMCEEngine.getPublicKeySize()];
        try {
            cMCEEngine.kem_keypair(byArray2, byArray, this.random);
        }
        catch (IOException iOException) {
            throw new IllegalStateException("kem_keypair failed!", iOException);
        }
        CMCEPublicKeyParameters cMCEPublicKeyParameters = new CMCEPublicKeyParameters(this.cmceParams.getParameters(), byArray2);
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = new CMCEPrivateKeyParameters(this.cmceParams.getParameters(), byArray);
        return new AsymmetricCipherKeyPair(cMCEPublicKeyParameters, cMCEPrivateKeyParameters);
    }

    public void init(CMCEKeyGenerationParameters cMCEKeyGenerationParameters) {
        this.initialize(cMCEKeyGenerationParameters);
    }

    public AsymmetricCipherKeyPair generateKeyPair() {
        return this.genKeyPair();
    }
}

