/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import org.bouncycastle.pqc.addon.CMCEEngine;
import org.bouncycastle.pqc.addon.CMCEKeyParameters;
import org.bouncycastle.pqc.addon.CMCEParameters;
import org.bouncycastle.pqc.addon.CMCEPrivateKeyParameters;
import org.bouncycastle.pqc.addon.EncapsulatedSecretExtractor;

class CMCEKEMExtractor
implements EncapsulatedSecretExtractor {
    private CMCEEngine engine;
    private CMCEKeyParameters key;

    public CMCEKEMExtractor(CMCEPrivateKeyParameters cMCEPrivateKeyParameters) {
        this.key = cMCEPrivateKeyParameters;
        this.initCipher(this.key.getParameters());
    }

    private void initCipher(CMCEParameters cMCEParameters) {
        this.engine = cMCEParameters.getEngine();
        CMCEPrivateKeyParameters cMCEPrivateKeyParameters = (CMCEPrivateKeyParameters)this.key;
        if (cMCEPrivateKeyParameters.getPrivateKey().length < this.engine.getPrivateKeySize()) {
            try {
                this.key = new CMCEPrivateKeyParameters(cMCEPrivateKeyParameters.getParameters(), this.engine.decompress_private_key(cMCEPrivateKeyParameters.getPrivateKey()));
            }
            catch (IOException iOException) {
                throw new IllegalStateException("private key failed!", iOException);
            }
        }
    }

    public byte[] extractSecret(byte[] byArray) {
        return this.extractSecret(byArray, this.engine.getDefaultSessionKeySize());
    }

    public byte[] extractSecret(byte[] byArray, int n) {
        byte[] byArray2 = new byte[n / 8];
        try {
            this.engine.kem_dec(byArray2, byArray, ((CMCEPrivateKeyParameters)this.key).getPrivateKey());
        }
        catch (IOException iOException) {
            throw new IllegalStateException("kem_dec failed!", iOException);
        }
        return byArray2;
    }

    public int getInputSize() {
        return this.engine.getCipherTextSize();
    }
}

