/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pqc.addon;

import java.io.IOException;
import java.security.SecureRandom;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.crypto.UpdateOutputStream;
import org.bouncycastle.crypto.fips.FipsOutputXOFCalculator;
import org.bouncycastle.crypto.fips.FipsParameters;
import org.bouncycastle.crypto.fips.FipsSHS;
import org.bouncycastle.pqc.addon.AsymmetricCipherKeyPair;
import org.bouncycastle.pqc.addon.ExchangePair;
import org.bouncycastle.pqc.addon.NHAgreement;
import org.bouncycastle.pqc.addon.NHExchangePairGenerator;
import org.bouncycastle.pqc.addon.NHKeyPairGenerator;
import org.bouncycastle.pqc.addon.NHPrivateKeyParameters;
import org.bouncycastle.pqc.addon.NHPublicKeyParameters;
import org.bouncycastle.pqc.addon.NHUtils;
import org.bouncycastle.pqc.addon.SecretKeyProcessor;
import org.bouncycastle.util.Arrays;

public class NHSecretKeyProcessor
implements SecretKeyProcessor {
    private final FipsOutputXOFCalculator xofOperator;

    private NHSecretKeyProcessor(byte[] byArray, byte[] byArray2) {
        FipsSHS.XOFOperatorFactory xOFOperatorFactory = new FipsSHS.XOFOperatorFactory();
        this.xofOperator = xOFOperatorFactory.createOutputXOFCalculator((FipsParameters)FipsSHS.SHAKE256);
        try {
            UpdateOutputStream updateOutputStream = this.xofOperator.getFunctionStream();
            updateOutputStream.write(byArray);
            if (byArray2 != null) {
                updateOutputStream.write(byArray2);
            }
            updateOutputStream.close();
        }
        catch (IOException iOException) {
            throw new IllegalStateException("unable to initialize XOF: " + iOException.getMessage(), iOException);
        }
        Arrays.fill((byte[])byArray, (byte)0);
    }

    public SecretKey processKey(SecretKey secretKey) {
        byte[] byArray = secretKey.getEncoded();
        byte[] byArray2 = this.xofOperator.getFunctionOutput(byArray.length);
        NHSecretKeyProcessor.xor(byArray, byArray2);
        Arrays.fill((byte[])byArray2, (byte)0);
        return new SecretKeySpec(byArray, secretKey.getAlgorithm());
    }

    private static void xor(byte[] byArray, byte[] byArray2) {
        for (int i = 0; i != byArray.length; ++i) {
            int n = i;
            byArray[n] = (byte)(byArray[n] ^ byArray2[i]);
        }
    }

    public static class PartyUBuilder {
        private final AsymmetricCipherKeyPair aKp;
        private final NHAgreement agreement = new NHAgreement();
        private byte[] sharedInfo = null;
        private boolean used = false;

        public PartyUBuilder(SecureRandom secureRandom) {
            NHKeyPairGenerator nHKeyPairGenerator = new NHKeyPairGenerator();
            nHKeyPairGenerator.init(secureRandom);
            this.aKp = nHKeyPairGenerator.generateKeyPair();
            this.agreement.init((NHPrivateKeyParameters)this.aKp.getPrivate());
        }

        public PartyUBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone((byte[])byArray);
            return this;
        }

        public byte[] getPartA() {
            return NHUtils.getEncoded((NHPublicKeyParameters)this.aKp.getPublic());
        }

        public SecretKeyProcessor build(byte[] byArray) {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return new NHSecretKeyProcessor(this.agreement.calculateAgreement(NHUtils.getPublicKey(byArray)), this.sharedInfo);
        }
    }

    public static class PartyVBuilder {
        protected final SecureRandom random;
        private byte[] sharedInfo = null;
        private byte[] sharedSecret = null;
        private boolean used = false;

        public PartyVBuilder(SecureRandom secureRandom) {
            this.random = secureRandom;
        }

        public PartyVBuilder withSharedInfo(byte[] byArray) {
            this.sharedInfo = Arrays.clone((byte[])byArray);
            return this;
        }

        public byte[] getPartB(byte[] byArray) {
            NHExchangePairGenerator nHExchangePairGenerator = new NHExchangePairGenerator(this.random);
            ExchangePair exchangePair = nHExchangePairGenerator.generateExchange(NHUtils.getPublicKey(byArray));
            this.sharedSecret = exchangePair.getSharedValue();
            return NHUtils.getEncoded((NHPublicKeyParameters)exchangePair.getPublicKey());
        }

        public SecretKeyProcessor build() {
            if (this.used) {
                throw new IllegalStateException("builder already used");
            }
            this.used = true;
            return new NHSecretKeyProcessor(this.sharedSecret, this.sharedInfo);
        }
    }
}

