/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.io.IOException;
import java.io.OutputStream;
import java.security.AccessController;
import java.security.AlgorithmParameters;
import java.security.GeneralSecurityException;
import java.security.Key;
import java.security.PrivilegedAction;
import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import org.bouncycastle.asn1.cms.GCMParameters;
import org.bouncycastle.asn1.oiw.OIWObjectIdentifiers;
import org.bouncycastle.asn1.pkcs.PKCSObjectIdentifiers;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.cms.CMSAlgorithm;
import org.bouncycastle.cms.CMSException;
import org.bouncycastle.cms.jcajce.DefaultJcaJceExtHelper;
import org.bouncycastle.cms.jcajce.EnvelopedDataHelper;
import org.bouncycastle.cms.jcajce.JceAADStream;
import org.bouncycastle.cms.jcajce.NamedJcaJceExtHelper;
import org.bouncycastle.cms.jcajce.ProviderJcaJceExtHelper;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.io.CipherOutputStream;
import org.bouncycastle.operator.DefaultSecretKeySizeProvider;
import org.bouncycastle.operator.GenericKey;
import org.bouncycastle.operator.MacCaptureStream;
import org.bouncycastle.operator.OutputAEADEncryptor;
import org.bouncycastle.operator.OutputEncryptor;
import org.bouncycastle.operator.SecretKeySizeProvider;
import org.bouncycastle.operator.jcajce.JceGenericKey;
import org.bouncycastle.util.Strings;

public class JceCMSContentEncryptorBuilder {
    private static final SecretKeySizeProvider KEY_SIZE_PROVIDER = DefaultSecretKeySizeProvider.INSTANCE;
    private static final byte[] hkdfSalt = Strings.toByteArray((String)"The Cryptographic Message Syntax");
    private final ASN1ObjectIdentifier encryptionOID;
    private final int keySize;
    private EnvelopedDataHelper helper = new EnvelopedDataHelper(new DefaultJcaJceExtHelper());
    private SecureRandom random;
    private AlgorithmIdentifier algorithmIdentifier;
    private AlgorithmParameters algorithmParameters;
    private ASN1ObjectIdentifier kdfAlgorithm;

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID) {
        this(encryptionOID, KEY_SIZE_PROVIDER.getKeySize(encryptionOID));
    }

    public JceCMSContentEncryptorBuilder(ASN1ObjectIdentifier encryptionOID, int keySize) {
        this.encryptionOID = encryptionOID;
        int fixedSize = KEY_SIZE_PROVIDER.getKeySize(encryptionOID);
        if (encryptionOID.equals((ASN1Primitive)PKCSObjectIdentifiers.des_EDE3_CBC)) {
            if (keySize != 168 && keySize != fixedSize) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = 168;
        } else if (encryptionOID.equals((ASN1Primitive)OIWObjectIdentifiers.desCBC)) {
            if (keySize != 56 && keySize != fixedSize) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = 56;
        } else {
            if (fixedSize > 0 && fixedSize != keySize) {
                throw new IllegalArgumentException("incorrect keySize for encryptionOID passed to builder.");
            }
            this.keySize = keySize;
        }
    }

    public JceCMSContentEncryptorBuilder(AlgorithmIdentifier encryptionAlgId) {
        this(encryptionAlgId.getAlgorithm(), KEY_SIZE_PROVIDER.getKeySize(encryptionAlgId.getAlgorithm()));
        this.algorithmIdentifier = encryptionAlgId;
    }

    public JceCMSContentEncryptorBuilder setEnableSha256HKdf(boolean useSha256Hkdf) {
        if (useSha256Hkdf) {
            this.kdfAlgorithm = CMSObjectIdentifiers.id_alg_cek_hkdf_sha256;
        } else if (this.kdfAlgorithm != null) {
            if (this.kdfAlgorithm.equals((ASN1Primitive)CMSObjectIdentifiers.id_alg_cek_hkdf_sha256)) {
                this.kdfAlgorithm = null;
            } else {
                throw new IllegalStateException("SHA256 HKDF not enabled");
            }
        }
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(Provider provider) {
        this.helper = new EnvelopedDataHelper(new ProviderJcaJceExtHelper(provider));
        return this;
    }

    public JceCMSContentEncryptorBuilder setProvider(String providerName) {
        this.helper = new EnvelopedDataHelper(new NamedJcaJceExtHelper(providerName));
        return this;
    }

    public JceCMSContentEncryptorBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    public JceCMSContentEncryptorBuilder setAlgorithmParameters(AlgorithmParameters algorithmParameters) {
        this.algorithmParameters = algorithmParameters;
        return this;
    }

    public OutputEncryptor build() throws CMSException {
        KeyGenerator keyGen = this.helper.createKeyGenerator(this.encryptionOID);
        this.random = CryptoServicesRegistrar.getSecureRandom((SecureRandom)this.random);
        if (this.keySize < 0) {
            keyGen.init(this.random);
        } else {
            keyGen.init(this.keySize, this.random);
        }
        return this.build(keyGen.generateKey());
    }

    public OutputEncryptor build(byte[] rawEncKey) throws CMSException {
        SecretKeySpec encKey = new SecretKeySpec(rawEncKey, this.helper.getBaseCipherName(this.encryptionOID));
        return this.build(encKey);
    }

    public OutputEncryptor build(SecretKey encKey) throws CMSException {
        ASN1Encodable params;
        if (this.algorithmParameters != null) {
            if (this.helper.isAuthEnveloped(this.encryptionOID)) {
                return new CMSAuthOutputEncryptor(this.kdfAlgorithm, this.encryptionOID, encKey, this.algorithmParameters, this.random);
            }
            return new CMSOutputEncryptor(this.kdfAlgorithm, this.encryptionOID, encKey, this.algorithmParameters, this.random);
        }
        if (this.algorithmIdentifier != null && (params = this.algorithmIdentifier.getParameters()) != null && !params.equals((Object)DERNull.INSTANCE)) {
            try {
                this.algorithmParameters = this.helper.createAlgorithmParameters(this.algorithmIdentifier.getAlgorithm());
                this.algorithmParameters.init(params.toASN1Primitive().getEncoded());
            }
            catch (Exception e) {
                throw new CMSException("unable to process provided algorithmIdentifier: " + e.toString(), e);
            }
        }
        if (this.helper.isAuthEnveloped(this.encryptionOID)) {
            return new CMSAuthOutputEncryptor(this.kdfAlgorithm, this.encryptionOID, encKey, this.algorithmParameters, this.random);
        }
        return new CMSOutputEncryptor(this.kdfAlgorithm, this.encryptionOID, encKey, this.algorithmParameters, this.random);
    }

    private static boolean checkForAEAD() {
        return (Boolean)AccessController.doPrivileged(new PrivilegedAction(){

            public Object run() {
                try {
                    return Cipher.class.getMethod("updateAAD", byte[].class) != null;
                }
                catch (Exception ignore) {
                    return Boolean.FALSE;
                }
            }
        });
    }

    private class CMSAuthOutputEncryptor
    extends CMSOutEncryptor
    implements OutputAEADEncryptor {
        private MacCaptureStream macOut;

        CMSAuthOutputEncryptor(ASN1ObjectIdentifier kdfAlgorithm, ASN1ObjectIdentifier encryptionOID, SecretKey encKey, AlgorithmParameters params, SecureRandom random) throws CMSException {
            this.init(kdfAlgorithm, encryptionOID, encKey, params, random);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            AlgorithmIdentifier algId = JceCMSContentEncryptorBuilder.this.kdfAlgorithm != null ? AlgorithmIdentifier.getInstance((Object)this.algorithmIdentifier.getParameters()) : this.algorithmIdentifier;
            if (CMSAlgorithm.ChaCha20Poly1305.equals((ASN1Primitive)this.algorithmIdentifier.getAlgorithm())) {
                this.macOut = new MacCaptureStream(dOut, 16);
            } else {
                GCMParameters p = GCMParameters.getInstance((Object)algId.getParameters());
                this.macOut = new MacCaptureStream(dOut, p.getIcvLen());
            }
            return new CipherOutputStream((OutputStream)this.macOut, this.cipher);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.algorithmIdentifier, this.encKey);
        }

        @Override
        public OutputStream getAADStream() {
            if (JceCMSContentEncryptorBuilder.checkForAEAD()) {
                return new JceAADStream(this.cipher);
            }
            return null;
        }

        @Override
        public byte[] getMAC() {
            return this.macOut.getMac();
        }
    }

    private class CMSOutEncryptor {
        protected SecretKey encKey;
        protected AlgorithmIdentifier algorithmIdentifier;
        protected Cipher cipher;

        private CMSOutEncryptor() {
        }

        private void applyKdf(ASN1ObjectIdentifier kdfAlgorithm, AlgorithmParameters params, SecureRandom random) throws CMSException {
            HKDFBytesGenerator kdf = new HKDFBytesGenerator((Digest)new SHA256Digest());
            byte[] encKeyEncoded = this.encKey.getEncoded();
            try {
                kdf.init((DerivationParameters)new HKDFParameters(encKeyEncoded, hkdfSalt, this.algorithmIdentifier.getEncoded("DER")));
            }
            catch (IOException e) {
                throw new CMSException("unable to encode enc algorithm parameters", e);
            }
            kdf.generateBytes(encKeyEncoded, 0, encKeyEncoded.length);
            SecretKeySpec derivedKey = new SecretKeySpec(encKeyEncoded, this.encKey.getAlgorithm());
            try {
                this.cipher.init(1, (Key)derivedKey, params, random);
            }
            catch (GeneralSecurityException e) {
                throw new CMSException("unable to initialize cipher: " + e.getMessage(), e);
            }
            this.algorithmIdentifier = new AlgorithmIdentifier(kdfAlgorithm, (ASN1Encodable)this.algorithmIdentifier);
        }

        protected void init(ASN1ObjectIdentifier kdfAlgorithm, ASN1ObjectIdentifier encryptionOID, SecretKey encKey, AlgorithmParameters params, SecureRandom random) throws CMSException {
            this.encKey = encKey;
            random = CryptoServicesRegistrar.getSecureRandom((SecureRandom)random);
            this.cipher = JceCMSContentEncryptorBuilder.this.helper.createCipher(encryptionOID);
            if (params == null) {
                params = JceCMSContentEncryptorBuilder.this.helper.generateParameters(encryptionOID, encKey, random);
            }
            if (params != null) {
                this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(encryptionOID, params);
                if (kdfAlgorithm != null) {
                    this.applyKdf(kdfAlgorithm, params, random);
                } else {
                    try {
                        this.cipher.init(1, (Key)encKey, params, random);
                    }
                    catch (GeneralSecurityException e) {
                        throw new CMSException("unable to initialize cipher: " + e.getMessage(), e);
                    }
                }
            } else {
                try {
                    this.cipher.init(1, (Key)encKey, params, random);
                }
                catch (GeneralSecurityException e) {
                    throw new CMSException("unable to initialize cipher: " + e.getMessage(), e);
                }
                params = this.cipher.getParameters();
                this.algorithmIdentifier = JceCMSContentEncryptorBuilder.this.helper.getAlgorithmIdentifier(encryptionOID, params);
                if (kdfAlgorithm != null) {
                    this.applyKdf(kdfAlgorithm, params, random);
                }
            }
        }
    }

    private class CMSOutputEncryptor
    extends CMSOutEncryptor
    implements OutputEncryptor {
        CMSOutputEncryptor(ASN1ObjectIdentifier kdfAlgorithm, ASN1ObjectIdentifier encryptionOID, SecretKey encKey, AlgorithmParameters params, SecureRandom random) throws CMSException {
            this.init(kdfAlgorithm, encryptionOID, encKey, params, random);
        }

        @Override
        public AlgorithmIdentifier getAlgorithmIdentifier() {
            return this.algorithmIdentifier;
        }

        @Override
        public OutputStream getOutputStream(OutputStream dOut) {
            return new CipherOutputStream(dOut, this.cipher);
        }

        @Override
        public GenericKey getKey() {
            return new JceGenericKey(this.algorithmIdentifier, this.encKey);
        }
    }
}

