/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.cms.jcajce;

import java.math.BigInteger;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.cms.KEMRecipientId;
import org.bouncycastle.cms.jcajce.CMSUtils;

public class JceKEMRecipientId
extends KEMRecipientId {
    public JceKEMRecipientId(X509Certificate certificate) {
        super(JceKEMRecipientId.convertPrincipal(certificate.getIssuerX500Principal()), certificate.getSerialNumber(), CMSUtils.getSubjectKeyId(certificate));
    }

    public JceKEMRecipientId(X500Principal issuer, BigInteger serialNumber) {
        super(JceKEMRecipientId.convertPrincipal(issuer), serialNumber);
    }

    public JceKEMRecipientId(X500Principal issuer, BigInteger serialNumber, byte[] subjectKeyId) {
        super(JceKEMRecipientId.convertPrincipal(issuer), serialNumber, subjectKeyId);
    }

    private static X500Name convertPrincipal(X500Principal issuer) {
        if (issuer == null) {
            return null;
        }
        return X500Name.getInstance((Object)issuer.getEncoded());
    }
}

