/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import org.bouncycastle.asn1.ASN1Sequence;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.Extensions;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;

public class DeltaCertificateRequestAttribute {
    private final X500Name subject;
    private final SubjectPublicKeyInfo subjectPKInfo;
    private final Extensions extensions;
    private final AlgorithmIdentifier signatureAlgorithm;

    public DeltaCertificateRequestAttribute(Attribute attribute) {
        ASN1Sequence seq = ASN1Sequence.getInstance((Object)attribute.getAttrValues().getObjectAt(0));
        int idx = 0;
        if (seq.getObjectAt(0) instanceof ASN1TaggedObject) {
            this.subject = X500Name.getInstance((ASN1TaggedObject)ASN1TaggedObject.getInstance((Object)seq.getObjectAt(0)), (boolean)true);
            ++idx;
        } else {
            this.subject = null;
        }
        this.subjectPKInfo = SubjectPublicKeyInfo.getInstance((Object)seq.getObjectAt(idx));
        Extensions ext = null;
        AlgorithmIdentifier sigAlg = null;
        if (++idx != seq.size()) {
            while (idx < seq.size()) {
                ASN1TaggedObject tagObj = ASN1TaggedObject.getInstance((Object)seq.getObjectAt(idx));
                if (tagObj.getTagNo() == 1) {
                    ext = Extensions.getInstance((ASN1TaggedObject)tagObj, (boolean)false);
                } else if (tagObj.getTagNo() == 2) {
                    sigAlg = AlgorithmIdentifier.getInstance((ASN1TaggedObject)tagObj, (boolean)false);
                } else {
                    throw new IllegalArgumentException("unknown tag");
                }
                ++idx;
            }
        }
        this.extensions = ext;
        this.signatureAlgorithm = sigAlg;
    }

    public X500Name getSubject() {
        return this.subject;
    }

    public SubjectPublicKeyInfo getSubjectPKInfo() {
        return this.subjectPKInfo;
    }

    public Extensions getExtensions() {
        return this.extensions;
    }

    public AlgorithmIdentifier getSignatureAlgorithm() {
        return this.signatureAlgorithm;
    }
}

