/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.pkcs;

import java.io.IOException;
import java.util.Enumeration;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1EncodableVector;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.DERSequence;
import org.bouncycastle.asn1.DERSet;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.asn1.pkcs.Attribute;
import org.bouncycastle.asn1.pkcs.CertificationRequest;
import org.bouncycastle.asn1.pkcs.CertificationRequestInfo;
import org.bouncycastle.asn1.x509.Extension;
import org.bouncycastle.operator.ContentVerifierProvider;
import org.bouncycastle.pkcs.DeltaCertificateRequestAttribute;
import org.bouncycastle.pkcs.PKCS10CertificationRequest;
import org.bouncycastle.pkcs.PKCSException;

public class DeltaCertAttributeUtils {
    public static Extension makeDeltaCertificateExtension(DeltaCertificateRequestAttribute deltaReqAttr) throws IOException {
        return null;
    }

    public static boolean isDeltaRequestSignatureValid(PKCS10CertificationRequest baseRequest, ContentVerifierProvider contentVerifierProvider) throws PKCSException {
        Attribute[] attributes = baseRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.2"));
        DeltaCertificateRequestAttribute deltaReq = new DeltaCertificateRequestAttribute(attributes[0]);
        attributes = baseRequest.getAttributes(new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"));
        CertificationRequest deltaPkcs10 = baseRequest.toASN1Structure();
        CertificationRequestInfo deltaInfo = deltaPkcs10.getCertificationRequestInfo();
        ASN1EncodableVector deltaPkcs10InfoV = new ASN1EncodableVector();
        deltaPkcs10InfoV.add((ASN1Encodable)deltaInfo.getVersion());
        deltaPkcs10InfoV.add((ASN1Encodable)deltaInfo.getSubject());
        deltaPkcs10InfoV.add((ASN1Encodable)deltaInfo.getSubjectPublicKeyInfo());
        ASN1EncodableVector attrSetV = new ASN1EncodableVector();
        Enumeration en = deltaInfo.getAttributes().getObjects();
        while (en.hasMoreElements()) {
            Attribute attr = Attribute.getInstance(en.nextElement());
            if (attr.getAttrType().equals((ASN1Primitive)new ASN1ObjectIdentifier("2.16.840.1.114027.80.6.3"))) continue;
            attrSetV.add((ASN1Encodable)attr);
        }
        deltaPkcs10InfoV.add((ASN1Encodable)new DERTaggedObject(false, 0, (ASN1Encodable)new DERSet(attrSetV)));
        ASN1EncodableVector deltaPkcs10V = new ASN1EncodableVector();
        deltaPkcs10V.add((ASN1Encodable)new DERSequence(deltaPkcs10InfoV));
        deltaPkcs10V.add((ASN1Encodable)deltaReq.getSignatureAlgorithm());
        deltaPkcs10V.add(attributes[0].getAttributeValues()[0]);
        PKCS10CertificationRequest deltaPkcs10Req = new PKCS10CertificationRequest(CertificationRequest.getInstance((Object)new DERSequence(deltaPkcs10V)));
        return deltaPkcs10Req.isSignatureValid(contentVerifierProvider);
    }
}

