/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.its.jcajce;

import java.lang.reflect.Constructor;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.security.spec.AlgorithmParameterSpec;
import org.bouncycastle.jcajce.spec.AEADParameterSpec;
import org.bouncycastle.util.Integers;

class ClassUtil {
    private static final Class gcmSpecClass = ClassUtil.loadClass(ClassUtil.class, "javax.crypto.spec.GCMParameterSpec");

    ClassUtil() {
    }

    public static AlgorithmParameterSpec getGCMSpec(final byte[] nonce, final int tagSize) {
        if (gcmSpecClass != null) {
            try {
                return (AlgorithmParameterSpec)AccessController.doPrivileged(new PrivilegedAction(){

                    public Object run() {
                        try {
                            Constructor cons = gcmSpecClass.getConstructor(Integer.TYPE, byte[].class);
                            return cons.newInstance(Integers.valueOf((int)tagSize), nonce);
                        }
                        catch (NoSuchMethodException e) {
                            throw new IllegalStateException("no matching constructor: " + e.getMessage());
                        }
                        catch (Exception e) {
                            throw new IllegalStateException("constructor failed" + e.getMessage());
                        }
                    }
                });
            }
            catch (IllegalStateException illegalStateException) {
                // empty catch block
            }
        }
        return new AEADParameterSpec(nonce, tagSize);
    }

    static Class loadClass(Class sourceClass, final String className) {
        try {
            ClassLoader loader = sourceClass.getClassLoader();
            if (loader != null) {
                return loader.loadClass(className);
            }
            return (Class)AccessController.doPrivileged(new PrivilegedAction(){

                public Object run() {
                    try {
                        return Class.forName(className);
                    }
                    catch (Exception exception) {
                        return null;
                    }
                }
            });
        }
        catch (ClassNotFoundException classNotFoundException) {
            return null;
        }
    }
}

