/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.est.jcajce;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.Collection;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.net.ssl.SSLSession;
import javax.security.auth.x500.X500Principal;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1String;
import org.bouncycastle.asn1.x500.AttributeTypeAndValue;
import org.bouncycastle.asn1.x500.RDN;
import org.bouncycastle.asn1.x500.X500Name;
import org.bouncycastle.asn1.x500.style.BCStyle;
import org.bouncycastle.est.ESTException;
import org.bouncycastle.est.jcajce.JsseHostnameAuthorizer;
import org.bouncycastle.util.IPAddress;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JsseDefaultHostnameAuthorizer
implements JsseHostnameAuthorizer {
    private static Logger LOG = Logger.getLogger(JsseDefaultHostnameAuthorizer.class.getName());
    private final Set<String> knownSuffixes;

    public JsseDefaultHostnameAuthorizer(Set<String> knownSuffixes) {
        this.knownSuffixes = knownSuffixes;
    }

    @Override
    public boolean verified(String name, SSLSession context) throws IOException {
        try {
            CertificateFactory fac = CertificateFactory.getInstance("X509");
            X509Certificate cert = (X509Certificate)fac.generateCertificate(new ByteArrayInputStream(context.getPeerCertificates()[0].getEncoded()));
            return this.verify(name, cert);
        }
        catch (Exception ex) {
            if (ex instanceof ESTException) {
                throw (ESTException)ex;
            }
            throw new ESTException(ex.getMessage(), ex);
        }
    }

    public boolean verify(String name, X509Certificate cert) throws IOException {
        if (name == null) {
            throw new NullPointerException("'name' cannot be null");
        }
        boolean foundAnyDNSNames = false;
        boolean nameIsIPv4 = IPAddress.isValidIPv4((String)name);
        boolean nameIsIPv6 = !nameIsIPv4 && IPAddress.isValidIPv6((String)name);
        boolean nameIsIPAddress = nameIsIPv4 || nameIsIPv6;
        try {
            Collection<List<?>> n = cert.getSubjectAlternativeNames();
            if (n != null) {
                InetAddress nameInetAddress = null;
                block8: for (List<?> l : n) {
                    int type = (Integer)l.get(0);
                    switch (type) {
                        case 2: {
                            if (!nameIsIPAddress && JsseDefaultHostnameAuthorizer.isValidNameMatch(name, (String)l.get(1), this.knownSuffixes)) {
                                return true;
                            }
                            foundAnyDNSNames = true;
                            break;
                        }
                        case 7: {
                            if (!nameIsIPAddress) continue block8;
                            String ipAddress = (String)l.get(1);
                            if (name.equalsIgnoreCase(ipAddress)) {
                                return true;
                            }
                            if (!nameIsIPv6 || !IPAddress.isValidIPv6((String)ipAddress)) continue block8;
                            try {
                                if (nameInetAddress == null) {
                                    nameInetAddress = InetAddress.getByName(name);
                                }
                                if (!nameInetAddress.equals(InetAddress.getByName(ipAddress))) continue block8;
                                return true;
                            }
                            catch (UnknownHostException unknownHostException) {
                                break;
                            }
                        }
                        default: {
                            if (!LOG.isLoggable(Level.INFO)) continue block8;
                            String value = l.get(1) instanceof byte[] ? Hex.toHexString((byte[])((byte[])l.get(1))) : l.get(1).toString();
                            LOG.log(Level.INFO, "ignoring type " + type + " value = " + value);
                        }
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ESTException(ex.getMessage(), ex);
        }
        if (nameIsIPAddress || foundAnyDNSNames) {
            return false;
        }
        X500Principal subject = cert.getSubjectX500Principal();
        if (subject == null) {
            return false;
        }
        RDN[] rdns = X500Name.getInstance((Object)subject.getEncoded()).getRDNs();
        for (int i = rdns.length - 1; i >= 0; --i) {
            AttributeTypeAndValue[] typesAndValues = rdns[i].getTypesAndValues();
            for (int j = 0; j != typesAndValues.length; ++j) {
                AttributeTypeAndValue typeAndValue = typesAndValues[j];
                if (!BCStyle.CN.equals((ASN1Primitive)typeAndValue.getType())) continue;
                ASN1Primitive commonName = typeAndValue.getValue().toASN1Primitive();
                return commonName instanceof ASN1String && JsseDefaultHostnameAuthorizer.isValidNameMatch(name, ((ASN1String)commonName).getString(), this.knownSuffixes);
            }
        }
        return false;
    }

    public static boolean isValidNameMatch(String name, String dnsName, Set<String> suffixes) throws IOException {
        if (dnsName.contains("*")) {
            int wildIndex = dnsName.indexOf(42);
            if (wildIndex == dnsName.lastIndexOf("*")) {
                if (dnsName.contains("..") || dnsName.charAt(dnsName.length() - 1) == '*') {
                    return false;
                }
                int dnsDotIndex = dnsName.indexOf(46, wildIndex);
                if (suffixes != null && suffixes.contains(Strings.toLowerCase((String)dnsName.substring(dnsDotIndex)))) {
                    throw new IOException("Wildcard `" + dnsName + "` matches known public suffix.");
                }
                String end = Strings.toLowerCase((String)dnsName.substring(wildIndex + 1));
                String loweredName = Strings.toLowerCase((String)name);
                if (loweredName.equals(end)) {
                    return false;
                }
                if (end.length() > loweredName.length()) {
                    return false;
                }
                if (wildIndex > 0) {
                    if (loweredName.startsWith(dnsName.substring(0, wildIndex)) && loweredName.endsWith(end)) {
                        return loweredName.substring(wildIndex, loweredName.length() - end.length()).indexOf(46) < 0;
                    }
                    return false;
                }
                String prefix = loweredName.substring(0, loweredName.length() - end.length());
                if (prefix.indexOf(46) > 0) {
                    return false;
                }
                return loweredName.endsWith(end);
            }
            return false;
        }
        return name.equalsIgnoreCase(dnsName);
    }
}

