/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;

public class BcPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();

    @Override
    public PGPContentVerifierBuilder get(int keyAlgorithm, int hashAlgorithm) throws PGPException {
        return new BcPGPContentVerifierBuilder(keyAlgorithm, hashAlgorithm);
    }

    private class BcPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public BcPGPContentVerifierBuilder(int keyAlgorithm, int hashAlgorithm) {
            this.keyAlgorithm = keyAlgorithm;
            this.hashAlgorithm = hashAlgorithm;
        }

        @Override
        public PGPContentVerifier build(final PGPPublicKey publicKey) throws PGPException {
            AsymmetricKeyParameter pubParam = BcPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(publicKey);
            final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, pubParam);
            signer.init(false, pubParam);
            return new PGPContentVerifier(){

                @Override
                public int getHashAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.hashAlgorithm;
                }

                @Override
                public int getKeyAlgorithm() {
                    return BcPGPContentVerifierBuilder.this.keyAlgorithm;
                }

                @Override
                public long getKeyID() {
                    return publicKey.getKeyID();
                }

                @Override
                public boolean verify(byte[] expected) {
                    return signer.verifySignature(expected);
                }

                @Override
                public OutputStream getOutputStream() {
                    return new SignerOutputStream(signer);
                }
            };
        }
    }
}

