/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.OutputStream;
import java.security.SecureRandom;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import org.bouncycastle.crypto.params.ParametersWithRandom;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPrivateKey;
import org.bouncycastle.openpgp.operator.PGPContentSigner;
import org.bouncycastle.openpgp.operator.PGPContentSignerBuilder;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcPGPKeyConverter;
import org.bouncycastle.openpgp.operator.bc.SignerOutputStream;
import org.bouncycastle.util.io.TeeOutputStream;

public class BcPGPContentSignerBuilder
implements PGPContentSignerBuilder {
    private BcPGPDigestCalculatorProvider digestCalculatorProvider = new BcPGPDigestCalculatorProvider();
    private BcPGPKeyConverter keyConverter = new BcPGPKeyConverter();
    private int hashAlgorithm;
    private SecureRandom random;
    private int keyAlgorithm;

    public BcPGPContentSignerBuilder(int keyAlgorithm, int hashAlgorithm) {
        this.keyAlgorithm = keyAlgorithm;
        this.hashAlgorithm = hashAlgorithm;
    }

    public BcPGPContentSignerBuilder setSecureRandom(SecureRandom random) {
        this.random = random;
        return this;
    }

    @Override
    public PGPContentSigner build(final int signatureType, final PGPPrivateKey privateKey) throws PGPException {
        AsymmetricKeyParameter privKeyParam = this.keyConverter.getPrivateKey(privateKey);
        final PGPDigestCalculator digestCalculator = this.digestCalculatorProvider.get(this.hashAlgorithm);
        final Signer signer = BcImplProvider.createSigner(this.keyAlgorithm, this.hashAlgorithm, privKeyParam);
        if (this.random != null) {
            signer.init(true, new ParametersWithRandom(privKeyParam, this.random));
        } else {
            signer.init(true, privKeyParam);
        }
        return new PGPContentSigner(){

            @Override
            public int getType() {
                return signatureType;
            }

            @Override
            public int getHashAlgorithm() {
                return BcPGPContentSignerBuilder.this.hashAlgorithm;
            }

            @Override
            public int getKeyAlgorithm() {
                return BcPGPContentSignerBuilder.this.keyAlgorithm;
            }

            @Override
            public long getKeyID() {
                return privateKey.getKeyID();
            }

            @Override
            public OutputStream getOutputStream() {
                return new TeeOutputStream(new SignerOutputStream(signer), digestCalculator.getOutputStream());
            }

            @Override
            public byte[] getSignature() {
                try {
                    return signer.generateSignature();
                }
                catch (CryptoException e) {
                    throw new IllegalStateException("unable to create signature");
                }
            }

            @Override
            public byte[] getDigest() {
                return digestCalculator.getDigest();
            }
        };
    }
}

