/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.oer.its.ieee1609dot2;

import org.bouncycastle.asn1.ASN1Choice;
import org.bouncycastle.asn1.ASN1Encodable;
import org.bouncycastle.asn1.ASN1Null;
import org.bouncycastle.asn1.ASN1Object;
import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.ASN1Primitive;
import org.bouncycastle.asn1.ASN1TaggedObject;
import org.bouncycastle.asn1.DERNull;
import org.bouncycastle.asn1.DEROctetString;
import org.bouncycastle.asn1.DERTaggedObject;
import org.bouncycastle.oer.its.ieee1609dot2.LinkageData;
import org.bouncycastle.oer.its.ieee1609dot2.basetypes.Hostname;

public class CertificateId
extends ASN1Object
implements ASN1Choice {
    public static final int linkageData = 0;
    public static final int name = 1;
    public static final int binaryId = 2;
    public static final int none = 3;
    private final int choice;
    private final ASN1Encodable certificateId;

    public CertificateId(int choice, ASN1Encodable value) {
        this.choice = choice;
        this.certificateId = value;
    }

    private CertificateId(ASN1TaggedObject asn1TaggedObject) {
        this.choice = asn1TaggedObject.getTagNo();
        switch (this.choice) {
            case 0: {
                this.certificateId = LinkageData.getInstance(asn1TaggedObject.getExplicitBaseObject());
                break;
            }
            case 1: {
                this.certificateId = Hostname.getInstance(asn1TaggedObject.getExplicitBaseObject());
                break;
            }
            case 2: {
                this.certificateId = DEROctetString.getInstance(asn1TaggedObject.getExplicitBaseObject());
                break;
            }
            case 3: {
                this.certificateId = ASN1Null.getInstance(asn1TaggedObject.getExplicitBaseObject());
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid choice value " + this.choice);
            }
        }
    }

    public static CertificateId linkageData(LinkageData linkageData) {
        return new CertificateId(0, linkageData);
    }

    public static CertificateId name(Hostname hostname) {
        return new CertificateId(1, hostname);
    }

    public static CertificateId binaryId(ASN1OctetString stream) {
        return new CertificateId(2, stream);
    }

    public static CertificateId binaryId(byte[] stream) {
        return new CertificateId(2, new DEROctetString(stream));
    }

    public static CertificateId none() {
        return new CertificateId(3, DERNull.INSTANCE);
    }

    public static CertificateId getInstance(Object o) {
        if (o instanceof CertificateId) {
            return (CertificateId)o;
        }
        if (o != null) {
            return new CertificateId(ASN1TaggedObject.getInstance(o, 128));
        }
        return null;
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.certificateId).toASN1Primitive();
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getCertificateId() {
        return this.certificateId;
    }
}

