/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.bouncycastle.openpgp.PGPExtendedKeyAttribute;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.util.Characters;
import org.bouncycastle.util.Strings;
import org.bouncycastle.util.encoders.Hex;
import org.bouncycastle.util.io.Streams;

public class SExpression {
    private static final Set<Character> labelStop = new HashSet<Character>(){
        {
            this.add(Characters.valueOf(' '));
            this.add(Characters.valueOf(')'));
            this.add(Characters.valueOf('('));
            this.add(Characters.valueOf('#'));
            this.add(Characters.valueOf('\"'));
            this.add(Characters.valueOf(':'));
        }
    };
    private final ArrayList<Object> values = new ArrayList();
    private boolean canonical = false;

    public SExpression(List<Object> values) {
        this.values.addAll(values);
    }

    public SExpression() {
    }

    public static SExpression parse(byte[] src, int maxDepth) throws IOException {
        return SExpression.parse(new ByteArrayInputStream(src), maxDepth);
    }

    public static SExpression parse(InputStream _src, int maxDepth) throws IOException {
        SExpression expr = null;
        return SExpression.parseExpression(_src, expr, new ByteArrayOutputStream(), maxDepth);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static SExpression parseExpression(InputStream src, SExpression expr, ByteArrayOutputStream accumulator, int maxDepth) throws IOException {
        Object key = null;
        if (accumulator == null) {
            accumulator = new ByteArrayOutputStream();
        }
        try {
            if (--maxDepth < 0) {
                throw new IllegalStateException("S-Expression exceeded maximum depth");
            }
            int c = 0;
            while (true) {
                if ((c = SExpression.consumeUntilSkipCRorLF(src, accumulator, labelStop)) == 58) {
                    int len = Integer.parseInt(Strings.fromByteArray(accumulator.toByteArray()));
                    byte[] b = new byte[len];
                    Streams.readFully(src, b);
                    expr.addValue(b);
                    expr.setCanonical(true);
                    continue;
                }
                if (accumulator.size() > 0) {
                    expr.addValue(Strings.fromByteArray(accumulator.toByteArray()));
                }
                if (c == 40) {
                    if (expr == null) {
                        expr = new SExpression();
                        SExpression.parseExpression(src, expr, accumulator, maxDepth);
                        SExpression sExpression = expr;
                        return sExpression;
                    }
                    expr.addValue(SExpression.parseExpression(src, new SExpression(), accumulator, maxDepth));
                    continue;
                }
                if (c == 35) {
                    SExpression.consumeUntilSkipWhiteSpace(src, accumulator, '#');
                    expr.addValue(Hex.decode(Strings.fromByteArray(accumulator.toByteArray())));
                    continue;
                }
                if (c == 34) {
                    SExpression.consumeUntilSkipCRorLF(src, accumulator, '\"');
                    expr.addValue(new QuotedString(Strings.fromByteArray(accumulator.toByteArray())));
                    continue;
                }
                if (c == 41) {
                    SExpression sExpression = expr;
                    return sExpression;
                }
                if (c == -1) break;
            }
        }
        finally {
            ++maxDepth;
        }
        return expr;
    }

    private static void consumeUntil(InputStream src, ByteArrayOutputStream accumulator, char item) throws IOException {
        int c;
        accumulator.reset();
        while ((c = src.read()) > -1) {
            if (c == item) {
                return;
            }
            accumulator.write(c);
        }
    }

    private static void consumeUntilSkipWhiteSpace(InputStream src, ByteArrayOutputStream accumulator, char item) throws IOException {
        int c;
        accumulator.reset();
        while ((c = src.read()) > -1) {
            if (c <= 32) continue;
            if (c == item) {
                return;
            }
            accumulator.write(c);
        }
    }

    private static int consumeUntilSkipCRorLF(InputStream src, ByteArrayOutputStream accumulator, Set<Character> characterSet) throws IOException {
        int c;
        accumulator.reset();
        boolean lineEnd = false;
        while ((c = src.read()) > -1) {
            if (lineEnd && c <= 32) {
                lineEnd = false;
                continue;
            }
            if (c == 10) {
                lineEnd = true;
                continue;
            }
            if (characterSet.contains(Characters.valueOf((char)c))) {
                return c;
            }
            accumulator.write(c);
        }
        return -1;
    }

    private static int consumeUntilSkipCRorLF(InputStream src, ByteArrayOutputStream accumulator, char ch) throws IOException {
        int c;
        accumulator.reset();
        boolean lineEnd = false;
        while ((c = src.read()) > -1) {
            if (lineEnd && c <= 32) {
                lineEnd = false;
                continue;
            }
            if (c == 10) {
                lineEnd = true;
                continue;
            }
            if (ch == c) {
                return c;
            }
            accumulator.write(c);
        }
        return -1;
    }

    public static Builder builder() {
        return new Builder();
    }

    public void addValue(Object value) {
        this.values.add(value);
    }

    public Object getValue(int i) {
        return this.values.get(i);
    }

    public String getString(int i) {
        Object val = this.values.get(i);
        if (val instanceof byte[]) {
            return Strings.fromUTF8ByteArray((byte[])val);
        }
        return this.values.get(i).toString();
    }

    public int getInt(int i) {
        return Integer.parseInt(this.getString(i));
    }

    public byte[] getBytes(int i) {
        return (byte[])this.values.get(i);
    }

    public SExpression getExpression(int i) {
        return (SExpression)this.values.get(i);
    }

    public List<Object> getValues() {
        return this.values;
    }

    public boolean isCanonical() {
        return this.canonical;
    }

    private void setCanonical(boolean canonical) {
        this.canonical = canonical;
    }

    public PGPExtendedKeyAttribute toAttribute() {
        PGPExtendedKeyAttribute.Builder builder = PGPExtendedKeyAttribute.builder();
        Iterator<Object> it = this.values.iterator();
        while (it.hasNext()) {
            builder.addAttribute(it.next());
        }
        return builder.build();
    }

    public SExpression filterOut(String ... keys) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(keys));
        SExpression expr = new SExpression();
        for (Object item : this.values) {
            if (set.contains(item.toString())) continue;
            if (item instanceof SExpression) {
                String label;
                if (!((SExpression)item).values.isEmpty() && set.contains(label = ((SExpression)item).values.get(0).toString())) continue;
                expr.values.add(((SExpression)item).filterOut(keys));
                continue;
            }
            expr.values.add(item);
        }
        return expr;
    }

    public SExpression filterIn(String ... keys) {
        HashSet<String> set = new HashSet<String>();
        set.addAll(Arrays.asList(keys));
        SExpression expr = new SExpression();
        for (Object item : this.values) {
            if (item instanceof SExpression) {
                String label;
                if (!((SExpression)item).values.isEmpty() && !set.contains(label = ((SExpression)item).values.get(0).toString())) continue;
                expr.values.add(item);
                continue;
            }
            if (!set.contains(item.toString())) continue;
            expr.values.add(item);
        }
        return expr;
    }

    public byte[] toCanonicalForm() {
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        try {
            this.toCanonicalForm(bos);
        }
        catch (Exception ex) {
            throw new PGPRuntimeOperationException(ex.getMessage(), ex);
        }
        return bos.toByteArray();
    }

    public void toCanonicalForm(OutputStream out) throws IOException {
        out.write(40);
        boolean space = false;
        for (Object value : this.values) {
            String s;
            if (value instanceof QuotedString) {
                s = ((QuotedString)value).value;
                out.write(Strings.toByteArray(Integer.toString(s.length())));
                out.write(58);
                out.write(Strings.toUTF8ByteArray(s));
                continue;
            }
            if (value instanceof String) {
                s = (String)value;
                out.write(Strings.toByteArray(Integer.toString(s.length())));
                out.write(58);
                out.write(Strings.toUTF8ByteArray(s));
                continue;
            }
            if (value instanceof byte[]) {
                byte[] b = (byte[])value;
                out.write(Strings.toByteArray(Integer.toString(b.length)));
                out.write(58);
                out.write(b);
                continue;
            }
            if (value instanceof SExpression) {
                ((SExpression)value).toCanonicalForm(out);
                continue;
            }
            throw new IllegalStateException("unhandled type " + value.getClass().getName() + " in value list");
        }
        out.write(41);
        out.flush();
    }

    public boolean hasLabel(String label) {
        if (this.values.isEmpty()) {
            throw new IllegalArgumentException("S-Expression is empty");
        }
        Object val = this.values.get(0);
        val = val instanceof String || val instanceof QuotedString ? val.toString() : Strings.fromByteArray((byte[])val);
        return val.equals(label);
    }

    public SExpression getExpressionWithLabel(String label) {
        for (Object o : this.values) {
            if (!(o instanceof SExpression) || !((SExpression)o).hasLabel(label)) continue;
            return (SExpression)o;
        }
        return null;
    }

    public SExpression getExpressionWithLabelOrFail(String label) {
        for (Object o : this.values) {
            if (!(o instanceof SExpression) || !((SExpression)o).hasLabel(label)) continue;
            return (SExpression)o;
        }
        throw new IllegalArgumentException("label " + label + " was not found");
    }

    public static class Builder {
        List<Object> values = new ArrayList<Object>();

        public Builder addValue(Object value) {
            this.values.add(value);
            return this;
        }

        public SExpression build() {
            return new SExpression(this.values);
        }

        public Builder addContent(SExpression other) {
            Iterator it = other.values.iterator();
            while (it.hasNext()) {
                this.values.add(it.next());
            }
            return this;
        }
    }

    public static class QuotedString {
        private final String value;

        public QuotedString(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

