/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeGCMSIVPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESGCMSIVModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.modes.gcm.GCMUtil;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Pack;

public class AESGCMSIVPacketCipher
implements AESGCMSIVModePacketCipher {
    private static final int HALFBUFLEN = 8;
    private static final int MAX_DATALEN = 0x7FFFFFE7;
    private static final byte MASK = -128;
    private static final byte ADD = -31;

    public static AESGCMSIVModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/GCMSIV-PC")) {
            return new AESNativeGCMSIVPacketCipher();
        }
        return new AESGCMSIVPacketCipher();
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        int macSize = 16;
        if (encryption) {
            return PacketCipherChecks.addCheckInputOverflow(len, 16);
        }
        if (len < 16) {
            throw new DataLengthException("len parameter invalid");
        }
        this.checkParameters(parameters);
        return len - 16;
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        byte[] myKeyOwned;
        byte[] myNonceOwned;
        PacketCipherChecks.checkBoundsInput(input, inOff, len, output, outOff);
        PacketCipherChecks.checkInputAndOutputAEAD(encryption, input, inOff, len, output, outOff, 16);
        byte[] theGHash = new byte[16];
        byte[] theReverse = new byte[16];
        GCMSIVHasher theAEADHasher = new GCMSIVHasher();
        GCMSIVHasher theDataHasher = new GCMSIVHasher();
        byte[] myInitialAEAD = null;
        long[][] T = new long[256][2];
        byte[] myResult = new byte[16];
        if (parameters instanceof AEADParameters) {
            AEADParameters myAEAD = (AEADParameters)parameters;
            myInitialAEAD = myAEAD.getAssociatedText();
            myNonceOwned = myAEAD.getNonce();
            PacketCipherChecks.checkKeyLengthExclude192(myAEAD.getKey().getKeyLength());
            myKeyOwned = Arrays.clone(myAEAD.getKey().getKey());
        } else if (parameters instanceof ParametersWithIV) {
            ParametersWithIV myParms = (ParametersWithIV)parameters;
            myNonceOwned = Arrays.clone(myParms.getIV());
            PacketCipherChecks.checkKeyLengthExclude192(((KeyParameter)myParms.getParameters()).getKeyLength());
            myKeyOwned = Arrays.clone(((KeyParameter)myParms.getParameters()).getKey());
        } else {
            throw PacketCipherException.from(new IllegalArgumentException("invalid parameters passed to GCM-SIV"));
        }
        if (myNonceOwned == null || myNonceOwned.length != 12) {
            throw PacketCipherException.from(new IllegalArgumentException("invalid nonce"));
        }
        byte[] s = AESPacketCipher.createS(true);
        int[][] workingKey = AESPacketCipher.generateWorkingKey(true, myKeyOwned);
        byte[] myEncKey = new byte[myKeyOwned.length];
        int outputLen = encryption ? len + 16 : len - 16;
        try {
            System.arraycopy(myNonceOwned, 0, theGHash, 4, 12);
            AESGCMSIVPacketCipher.deriveKey(workingKey, s, theGHash, theReverse, myResult, 0);
            theGHash[0] = (byte)(theGHash[0] + 1);
            int myOff = AESGCMSIVPacketCipher.deriveKey(workingKey, s, theGHash, theReverse, myEncKey, 0);
            if (myEncKey.length == 32) {
                theGHash[0] = (byte)(theGHash[0] + 1);
                AESGCMSIVPacketCipher.deriveKey(workingKey, s, theGHash, theReverse, myEncKey, myOff += 8);
            }
            int keyLen = myEncKey.length;
            PacketCipherChecks.checkKeyLength(keyLen);
            Arrays.clear(workingKey);
            Arrays.clear(s);
            s = AESPacketCipher.createS(true);
            workingKey = AESPacketCipher.generateWorkingKey(true, myEncKey);
            AESGCMSIVPacketCipher.fillReverse(myResult, 0, 16, theReverse);
            AESGCMSIVPacketCipher.mulX(theReverse);
            AESGCMSIVPacketCipher.initMultiplier(T, theReverse);
            Arrays.fill(theGHash, (byte)0);
            if (myInitialAEAD != null) {
                theAEADHasher.updateHash(myInitialAEAD, 0, myInitialAEAD.length, theReverse, theGHash, T);
            }
            theAEADHasher.completeHash(theReverse, theGHash, T);
            long dataLimit = 0x7FFFFFE7L;
            if (!encryption) {
                dataLimit += 16L;
            }
            if ((long)len + Long.MIN_VALUE > dataLimit - (long)len + Long.MIN_VALUE) {
                throw PacketCipherException.from(new IllegalStateException("byte count exceeded"));
            }
            if (encryption) {
                theDataHasher.updateHash(input, inOff, len, theReverse, theGHash, T);
                byte[] myTag = AESGCMSIVPacketCipher.calculateTag(theDataHasher, theAEADHasher, theReverse, theGHash, T, myNonceOwned, workingKey, s);
                AESGCMSIVPacketCipher.encryptPlain(input, inOff, len, myTag, output, outOff, workingKey, s);
                System.arraycopy(myTag, 0, output, outOff + len, 16);
            } else {
                AESGCMSIVPacketCipher.decryptPlain(theDataHasher, theAEADHasher, input, inOff, len, output, outOff, myNonceOwned, theReverse, theGHash, T, workingKey, s);
            }
        }
        catch (Throwable t) {
            Arrays.clear(output, outOff, Math.min(output.length - outOff, outputLen));
            throw PacketCipherException.from(t);
        }
        finally {
            Arrays.clear(workingKey);
            Arrays.clear(theGHash);
            Arrays.clear(theReverse);
            Arrays.clear(myNonceOwned);
            Arrays.clear(myKeyOwned);
            Arrays.clear(s);
        }
        return outputLen;
    }

    private static int deriveKey(int[][] workingKey, byte[] s, byte[] myIn, byte[] myOut, byte[] myEncKey, int myOff) {
        AESPacketCipher.processBlock(true, workingKey, s, myIn, 0, myOut, 0);
        System.arraycopy(myOut, 0, myEncKey, myOff, 8);
        myIn[0] = (byte)(myIn[0] + 1);
        AESPacketCipher.processBlock(true, workingKey, s, myIn, 0, myOut, 0);
        System.arraycopy(myOut, 0, myEncKey, myOff += 8, 8);
        return myOff;
    }

    private static byte[] calculateTag(GCMSIVHasher theDataHasher, GCMSIVHasher theAEADHasher, byte[] theReverse, byte[] theGHash, long[][] T, byte[] theNonce, int[][] workingKey, byte[] s) {
        theDataHasher.completeHash(theReverse, theGHash, T);
        byte[] myPolyVal = AESGCMSIVPacketCipher.completePolyVal(theDataHasher, theAEADHasher, theGHash, T);
        byte[] myResult = new byte[16];
        for (int i = 0; i < 12; ++i) {
            int n = i;
            myPolyVal[n] = (byte)(myPolyVal[n] ^ theNonce[i]);
        }
        myPolyVal[15] = (byte)(myPolyVal[15] & 0xFFFFFF7F);
        AESPacketCipher.processBlock(true, workingKey, s, myPolyVal, 0, myResult, 0);
        return myResult;
    }

    private static byte[] completePolyVal(GCMSIVHasher theDataHasher, GCMSIVHasher theAEADHasher, byte[] theGHash, long[][] T) {
        byte[] myResult = new byte[16];
        byte[] myIn = new byte[16];
        Pack.longToBigEndian(8L * theDataHasher.getBytesProcessed(), myIn, 0);
        Pack.longToBigEndian(8L * theAEADHasher.getBytesProcessed(), myIn, 8);
        AESGCMSIVPacketCipher.gHASH(myIn, theGHash, T);
        AESGCMSIVPacketCipher.fillReverse(theGHash, 0, 16, myResult);
        return myResult;
    }

    private static int encryptPlain(byte[] input, int inOff, int len, byte[] pCounter, byte[] pTarget, int pOffset, int[][] workingKey, byte[] s) {
        byte[] myCounter = Arrays.clone(pCounter);
        myCounter[15] = (byte)(myCounter[15] | 0xFFFFFF80);
        byte[] myMask = new byte[16];
        int myRemaining = len;
        while (myRemaining > 0) {
            AESPacketCipher.processBlock(true, workingKey, s, myCounter, 0, myMask, 0);
            int myLen = Math.min(16, myRemaining);
            AESGCMSIVPacketCipher.xorBlock(myMask, input, inOff, myLen);
            System.arraycopy(myMask, 0, pTarget, pOffset, myLen);
            myRemaining -= myLen;
            inOff += myLen;
            pOffset += myLen;
            AESGCMSIVPacketCipher.incrementCounter(myCounter);
        }
        return len;
    }

    private static void fillReverse(byte[] pInput, int pOffset, int pLength, byte[] pOutput) {
        int i = 0;
        int j = 15;
        while (i < pLength) {
            pOutput[j] = pInput[pOffset + i];
            ++i;
            --j;
        }
    }

    private static void gHASH(byte[] pNext, byte[] theGHash, long[][] T) {
        AESGCMSIVPacketCipher.xorBlock(theGHash, pNext);
        AESGCMSIVPacketCipher.mulH(theGHash, T);
    }

    protected static void mulH(byte[] x, long[][] T) {
        long[] t = T[x[15] & 0xFF];
        long z0 = t[0];
        long z1 = t[1];
        for (int i = 14; i >= 0; --i) {
            t = T[x[i] & 0xFF];
            long c = z1 << 56;
            z1 = t[1] ^ (z1 >>> 8 | z0 << 56);
            z0 = t[0] ^ z0 >>> 8 ^ c ^ c >>> 1 ^ c >>> 2 ^ c >>> 7;
        }
        Pack.longToBigEndian(z0, x, 0);
        Pack.longToBigEndian(z1, x, 8);
    }

    private static void xorBlock(byte[] pLeft, byte[] pRight) {
        for (int i = 0; i < 16; ++i) {
            int n = i;
            pLeft[n] = (byte)(pLeft[n] ^ pRight[i]);
        }
    }

    private static void xorBlock(byte[] pLeft, byte[] pRight, int pOffset, int pLength) {
        for (int i = 0; i < pLength; ++i) {
            int n = i;
            pLeft[n] = (byte)(pLeft[n] ^ pRight[i + pOffset]);
        }
    }

    private static void mulX(byte[] pValue) {
        int myMask = 0;
        for (int i = 0; i < 16; ++i) {
            byte myValue = pValue[i];
            pValue[i] = (byte)(myValue >> 1 & 0x7F | myMask);
            myMask = (myValue & 1) == 0 ? 0 : -128;
        }
        if (myMask != 0) {
            pValue[0] = (byte)(pValue[0] ^ 0xFFFFFFE1);
        }
    }

    private static void decryptPlain(GCMSIVHasher theDataHasher, GCMSIVHasher theAEADHasher, byte[] input, int inOff, int len, byte[] output, int outOff, byte[] theNonce, byte[] theReverse, byte[] theGHash, long[][] T, int[][] workingKey, byte[] s) throws PacketCipherException {
        int myRemaining = len - 16;
        byte[] myExpected = Arrays.copyOfRange(input, myRemaining + inOff, myRemaining + inOff + 16);
        byte[] myCounter = Arrays.clone(myExpected);
        myCounter[15] = (byte)(myCounter[15] | 0xFFFFFF80);
        byte[] myMask = new byte[16];
        int myOff = inOff;
        while (myRemaining > 0) {
            AESPacketCipher.processBlock(true, workingKey, s, myCounter, 0, myMask, 0);
            int myLen = Math.min(16, myRemaining);
            AESGCMSIVPacketCipher.xorBlock(myMask, input, myOff, myLen);
            System.arraycopy(myMask, 0, output, outOff, myLen);
            theDataHasher.updateHash(myMask, 0, myLen, theReverse, theGHash, T);
            myRemaining -= myLen;
            myOff += myLen;
            outOff += myLen;
            AESGCMSIVPacketCipher.incrementCounter(myCounter);
        }
        byte[] myTag = AESGCMSIVPacketCipher.calculateTag(theDataHasher, theAEADHasher, theReverse, theGHash, T, theNonce, workingKey, s);
        if (!Arrays.constantTimeAreEqual(myTag, myExpected)) {
            throw PacketCipherException.from(new InvalidCipherTextException("mac check failed"));
        }
    }

    protected static void initMultiplier(long[][] t, byte[] h) {
        GCMUtil.asLongs(h, t[1]);
        GCMUtil.multiplyP7(t[1], t[1]);
        for (int n = 2; n < 256; n += 2) {
            GCMUtil.divideP(t[n >> 1], t[n]);
            GCMUtil.xor(t[n], t[1], t[n + 1]);
        }
    }

    private static void incrementCounter(byte[] pCounter) {
        int i = 0;
        while (i < 4) {
            int n = i++;
            pCounter[n] = (byte)(pCounter[n] + 1);
            if (pCounter[n] != 0) break;
        }
    }

    public String toString() {
        return "GCMSIV-PS[Java](AES[Java])";
    }

    private static class GCMSIVHasher {
        private final byte[] theBuffer = new byte[16];
        private int numActive;
        private long numHashed;

        private GCMSIVHasher() {
        }

        long getBytesProcessed() {
            return this.numHashed;
        }

        void updateHash(byte[] pBuffer, int pOffset, int pLen, byte[] theReverse, byte[] theGHash, long[][] T) {
            int mySpace = 16 - this.numActive;
            int numProcessed = 0;
            int myRemaining = pLen;
            if (this.numActive > 0 && pLen >= mySpace) {
                System.arraycopy(pBuffer, pOffset, this.theBuffer, this.numActive, mySpace);
                AESGCMSIVPacketCipher.fillReverse(this.theBuffer, 0, 16, theReverse);
                AESGCMSIVPacketCipher.gHASH(theReverse, theGHash, T);
                numProcessed += mySpace;
                myRemaining -= mySpace;
                this.numActive = 0;
            }
            while (myRemaining >= 16) {
                AESGCMSIVPacketCipher.fillReverse(pBuffer, pOffset + numProcessed, 16, theReverse);
                AESGCMSIVPacketCipher.gHASH(theReverse, theGHash, T);
                numProcessed += 16;
                myRemaining -= 16;
            }
            if (myRemaining > 0) {
                System.arraycopy(pBuffer, pOffset + numProcessed, this.theBuffer, this.numActive, myRemaining);
                this.numActive += myRemaining;
            }
            this.numHashed += (long)pLen;
        }

        void completeHash(byte[] theReverse, byte[] theGHash, long[][] T) {
            if (this.numActive > 0) {
                Arrays.fill(theReverse, (byte)0);
                AESGCMSIVPacketCipher.fillReverse(this.theBuffer, 0, this.numActive, theReverse);
                AESGCMSIVPacketCipher.gHASH(theReverse, theGHash, T);
            }
        }
    }
}

