/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeCTRPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESCTRModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class AESCTRPacketCipher
implements AESCTRModePacketCipher {
    public static AESCTRModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CTR-PC")) {
            return new AESNativeCTRPacketCipher();
        }
        return new AESCTRPacketCipher();
    }

    private AESCTRPacketCipher() {
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        this.checkParameters(parameters);
        return len;
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters parameters, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int remaining;
        int ctrBits;
        int maxBlocks;
        int maxLen;
        KeyParameter keyParameter;
        byte[] ivOwned;
        PacketCipherChecks.checkBoundsInputAndOutput(input, inOff, len, output, outOff);
        if (len == 0) {
            return 0;
        }
        byte[] counter = new byte[16];
        byte[] counterOut = new byte[16];
        byte[] s = AESPacketCipher.createS(true);
        if (parameters instanceof ParametersWithIV) {
            ParametersWithIV ivParam = (ParametersWithIV)parameters;
            ivOwned = Arrays.clone(ivParam.getIV());
            if (ivOwned.length > 16) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV no greater than: 16 bytes.");
            }
            if (ivOwned.length < 8) {
                throw new IllegalArgumentException("CTR/SIC mode requires IV of at least: 8 bytes.");
            }
            System.arraycopy(ivOwned, 0, counter, 0, ivOwned.length);
            keyParameter = (KeyParameter)ivParam.getParameters();
            if (keyParameter == null) {
                throw PacketCipherException.from(new IllegalStateException("CTR/SIC cipher unitialized."));
            }
        } else {
            throw new IllegalArgumentException("CTR/SIC mode requires ParametersWithIV");
        }
        int keyLen = keyParameter.getKey().length;
        PacketCipherChecks.checkKeyLength(keyLen);
        int[][] workingKey = AESPacketCipher.generateWorkingKey(true, keyParameter.getKey());
        int ctrSize = 16 - ivOwned.length;
        if (ctrSize > 0 && ctrSize < 4 && len > (maxLen = (maxBlocks = 1 << (ctrBits = ctrSize * 8)) * 16)) {
            throw new IllegalStateException("Counter in CTR/SIC mode out of range.");
        }
        for (remaining = len; remaining > 16; remaining -= 16) {
            AESPacketCipher.processBlock(true, workingKey, s, counter, 0, counterOut, 0);
            Bytes.xor(16, input, inOff, counterOut, 0, output, outOff);
            AESCTRPacketCipher.incrementCounter(counter, ivOwned);
            inOff += 16;
            outOff += 16;
        }
        AESPacketCipher.processBlock(true, workingKey, s, counter, 0, counterOut, 0);
        Bytes.xor(remaining, input, inOff, counterOut, 0, output, outOff);
        Arrays.clear(counterOut);
        Arrays.clear(counter);
        Arrays.clear(ivOwned);
        Arrays.clear(workingKey);
        Arrays.clear(s);
        return len;
    }

    private static void incrementCounter(byte[] counter, byte[] iv) {
        int i = counter.length;
        while (--i >= 0) {
            int n = i;
            counter[n] = (byte)(counter[n] + 1);
            if (counter[n] == 0) continue;
            break;
        }
    }

    public String toString() {
        return "CTR-PS[Java](AES[Java])";
    }
}

