/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.modes;

import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoServicesRegistrar;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.crypto.OutputLengthException;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.engines.AESNativeCCMPacketCipher;
import org.bouncycastle.crypto.engines.AESPacketCipher;
import org.bouncycastle.crypto.modes.AESCCMModePacketCipher;
import org.bouncycastle.crypto.modes.PacketCipherChecks;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Bytes;

public class AESCCMPacketCipher
implements AESCCMModePacketCipher {
    public static AESCCMModePacketCipher newInstance() {
        if (CryptoServicesRegistrar.hasEnabledService("AES/CCM-PC")) {
            return new AESNativeCCMPacketCipher();
        }
        return new AESCCMPacketCipher();
    }

    @Override
    public int getOutputSize(boolean encryption, CipherParameters params, int len) {
        if (len < 0) {
            throw new IllegalArgumentException("input len is negative");
        }
        int macSize = this.getMacSize(encryption, params);
        if (encryption) {
            return PacketCipherChecks.addCheckInputOverflow(len, macSize);
        }
        if (len < macSize) {
            throw new OutputLengthException("output buffer too short");
        }
        return len - macSize;
    }

    @Override
    public int processPacket(boolean forEncryption, CipherParameters params, byte[] in, int inOff, int inLen, byte[] output, int outOff) throws PacketCipherException {
        int limitLen;
        KeyParameter keyParam;
        byte[] initialAssociatedText;
        byte[] nonce;
        int macSize;
        PacketCipherChecks.checkBoundsInput(in, inOff, inLen, output, outOff);
        byte[] macBlock = new byte[16];
        byte[] counter = new byte[16];
        byte[] counterOut = new byte[16];
        byte[] block = null;
        if (!forEncryption) {
            block = new byte[16];
        }
        try {
            CipherParameters param;
            if (params instanceof AEADParameters) {
                param = (AEADParameters)params;
                macSize = this.getCCMMacSize(forEncryption, ((AEADParameters)param).getMacSize());
                nonce = ((AEADParameters)param).getNonce();
                initialAssociatedText = ((AEADParameters)param).getAssociatedText();
                keyParam = ((AEADParameters)param).getKey();
            } else if (params instanceof ParametersWithIV) {
                param = (ParametersWithIV)params;
                macSize = 8;
                nonce = Arrays.clone(((ParametersWithIV)param).getIV());
                initialAssociatedText = null;
                keyParam = (KeyParameter)((ParametersWithIV)param).getParameters();
            } else {
                throw new IllegalArgumentException("invalid parameters passed to CCM");
            }
            PacketCipherChecks.checkInputAndOutputAEAD(forEncryption, in, inOff, inLen, output, outOff, macSize);
            if (nonce == null || nonce.length < 7 || nonce.length > 13) {
                throw new IllegalArgumentException("nonce must have length from 7 to 13 octets");
            }
            PacketCipherChecks.checkKeyLength(keyParam.getKeyLength());
        }
        catch (IllegalArgumentException e) {
            throw PacketCipherException.from(e);
        }
        int[][] workingKey = AESPacketCipher.generateWorkingKey(true, keyParam.getKey());
        byte[] s = AESPacketCipher.createS(true);
        int q = 15 - nonce.length;
        if (q < 4 && inLen >= (limitLen = 1 << (q << 3))) {
            throw PacketCipherException.from(new IllegalStateException("CCM packet too large for choice of q."));
        }
        PacketCipherException exception = null;
        int outputLen = 0;
        try {
            int inIndex;
            counter[0] = (byte)(q - 1 & 7);
            System.arraycopy(nonce, 0, counter, 1, nonce.length);
            int outIndex = outOff;
            if (forEncryption) {
                outputLen = PacketCipherChecks.addCheckInputOverflow(inLen, macSize);
                AESCCMPacketCipher.calculateMac(in, inOff, inLen, macBlock, macSize, initialAssociatedText, nonce, workingKey, s);
                AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, macBlock, 0, macBlock, 0, workingKey, s);
                System.arraycopy(macBlock, 0, output, outOff + inLen, macSize);
                for (inIndex = inOff; inIndex < inOff + inLen - 16; inIndex += 16) {
                    AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, in, inIndex, output, outIndex, workingKey, s);
                    outIndex += 16;
                }
                System.arraycopy(in, inIndex, macBlock, 0, inLen + inOff - inIndex);
                AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, macBlock, 0, macBlock, 0, workingKey, s);
                System.arraycopy(macBlock, 0, output, outIndex, inLen + inOff - inIndex);
            } else {
                outputLen = inLen - macSize;
                System.arraycopy(in, inOff + outputLen, macBlock, 0, macSize);
                AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, macBlock, 0, macBlock, 0, workingKey, s);
                Arrays.fill(macBlock, macSize, 16, (byte)0);
                while (inIndex < inOff + outputLen - 16) {
                    AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, in, inIndex, output, outIndex, workingKey, s);
                    outIndex += 16;
                    inIndex += 16;
                }
                System.arraycopy(in, inIndex, block, 0, outputLen - (inIndex - inOff));
                AESCCMPacketCipher.ctrProcessBlock(counter, counterOut, block, 0, block, 0, workingKey, s);
                System.arraycopy(block, 0, output, outIndex, outputLen - (inIndex - inOff));
                AESCCMPacketCipher.calculateMac(output, outOff, outputLen, block, macSize, initialAssociatedText, nonce, workingKey, s);
                if (!Arrays.constantTimeAreEqual(macBlock, block)) {
                    throw new InvalidCipherTextException("mac check in CCM failed");
                }
            }
        }
        catch (Exception ex) {
            exception = PacketCipherException.from(ex);
            throw exception;
        }
        finally {
            if (exception != null) {
                int l = Math.min(outputLen, output.length - outOff);
                Arrays.clear(output, outOff, l);
            }
        }
        Arrays.clear(workingKey);
        Arrays.clear(macBlock);
        Arrays.clear(counter);
        Arrays.clear(counterOut);
        Arrays.clear(block);
        Arrays.clear(s);
        return outputLen;
    }

    private static void calculateMac(byte[] in, int inOff, int inLen, byte[] macBlock, int macSize, byte[] aad, byte[] nonce, int[][] workingkey, byte[] s) {
        byte[] buf = new byte[16];
        int bufOff = 0;
        if (aad != null && aad.length > 0) {
            buf[0] = (byte)(buf[0] | 0x40);
        }
        buf[0] = (byte)(buf[0] | ((macSize - 2 >> 1 & 7) << 3 | 15 - nonce.length - 1 & 7));
        System.arraycopy(nonce, 0, buf, 1, nonce.length);
        int count = 1;
        for (int q = inLen; q > 0; q >>>= 8) {
            buf[buf.length - count++] = (byte)(q & 0xFF);
        }
        AESPacketCipher.processBlock(true, workingkey, s, buf, 0, macBlock, 0);
        if (aad != null && aad.length > 0) {
            int textLength = aad.length;
            if (textLength < 65280) {
                buf[0] = (byte)(textLength >> 8);
                buf[1] = (byte)textLength;
                bufOff = 2;
            } else {
                buf[0] = -1;
                buf[1] = -2;
                buf[2] = (byte)(textLength >> 24);
                buf[3] = (byte)(textLength >> 16);
                buf[4] = (byte)(textLength >> 8);
                buf[5] = (byte)textLength;
                bufOff = 6;
            }
            bufOff = AESCCMPacketCipher.cbcmacUpdate(buf, macBlock, bufOff, aad, 0, aad.length, workingkey, s);
            if (bufOff != 0) {
                Arrays.fill(buf, bufOff, 16, (byte)0);
                Bytes.xorTo(16, macBlock, 0, buf, 0);
                AESPacketCipher.processBlock(true, workingkey, s, buf, 0, macBlock, 0);
                bufOff = 0;
            }
        }
        if (inLen != 0) {
            bufOff = AESCCMPacketCipher.cbcmacUpdate(buf, macBlock, bufOff, in, inOff, inLen, workingkey, s);
            Arrays.fill(buf, bufOff, 16, (byte)0);
            Bytes.xorTo(16, buf, macBlock);
            AESPacketCipher.processBlock(true, workingkey, s, macBlock, 0, macBlock, 0);
        }
        Arrays.fill(macBlock, macSize, 16, (byte)0);
        Arrays.clear(buf);
    }

    private static int cbcmacUpdate(byte[] buf, byte[] accumulator, int bufOff, byte[] in, int inOff, int len, int[][] workingkey, byte[] s) {
        int gapLen = 16 - bufOff;
        if (len > gapLen) {
            System.arraycopy(in, inOff, buf, bufOff, gapLen);
            Bytes.xorTo(16, buf, accumulator);
            AESPacketCipher.processBlock(true, workingkey, s, accumulator, 0, accumulator, 0);
            bufOff = 0;
            len -= gapLen;
            inOff += gapLen;
            while (len > 16) {
                Bytes.xor(16, accumulator, 0, in, inOff, accumulator, 0);
                AESPacketCipher.processBlock(true, workingkey, s, accumulator, 0, accumulator, 0);
                len -= 16;
                inOff += 16;
            }
        }
        System.arraycopy(in, inOff, buf, bufOff, len);
        return bufOff += len;
    }

    protected static void ctrProcessBlock(byte[] counter, byte[] counterOut, byte[] in, int inOff, byte[] out, int outOff, int[][] workingkeys, byte[] s) {
        AESPacketCipher.processBlock(true, workingkeys, s, counter, 0, counterOut, 0);
        int i = counter.length;
        while (--i >= 0) {
            int n = i;
            counter[n] = (byte)(counter[n] + 1);
            if (counter[n] == 0) continue;
        }
        Bytes.xorTee(16, in, inOff, counterOut, 0, out, outOff);
    }

    public String toString() {
        return "CCM-PS[Java](AES[Java])";
    }
}

