/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.engines;

import javax.security.auth.DestroyFailedException;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.PacketCipherException;
import org.bouncycastle.crypto.modes.AESGCMModePacketCipher;
import org.bouncycastle.crypto.params.AEADParameters;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.util.Arrays;

public class AESNativeGCMPacketCipher
implements AESGCMModePacketCipher {
    private byte[] lastKey;
    private byte[] lastNonce;
    private boolean destroyed;

    @Override
    public int getOutputSize(boolean encryption, CipherParameters parameters, int len) {
        int macSize = this.checkParameters(parameters);
        return AESNativeGCMPacketCipher.getOutputSize(encryption, len, macSize);
    }

    @Override
    public int processPacket(boolean encryption, CipherParameters params, byte[] input, int inOff, int len, byte[] output, int outOff) throws PacketCipherException {
        int result;
        byte[] key;
        int macSize;
        byte[] initialAssociatedText;
        byte[] nonce;
        block9: {
            try {
                CipherParameters param;
                if (params instanceof AEADParameters) {
                    param = (AEADParameters)params;
                    nonce = ((AEADParameters)param).getNonce();
                    initialAssociatedText = ((AEADParameters)param).getAssociatedText();
                    int macSizeBits = ((AEADParameters)param).getMacSize();
                    if (macSizeBits < 32 || macSizeBits > 128 || (macSizeBits & 7) != 0) {
                        throw new IllegalArgumentException("invalid mac size: " + macSizeBits);
                    }
                    macSize = macSizeBits >> 3;
                    key = ((AEADParameters)param).getKey().getKey();
                    if (encryption && Arrays.areEqual(key, this.lastKey) && Arrays.areEqual(nonce, this.lastNonce)) {
                        throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                    }
                    this.lastKey = Arrays.clone(key);
                    this.lastNonce = Arrays.clone(nonce);
                    break block9;
                }
                if (params instanceof ParametersWithIV) {
                    param = (ParametersWithIV)params;
                    nonce = (byte[])((ParametersWithIV)param).getIV().clone();
                    initialAssociatedText = null;
                    macSize = 16;
                    key = ((KeyParameter)((ParametersWithIV)param).getParameters()).getKey();
                    if (encryption && Arrays.areEqual(key, this.lastKey) && Arrays.areEqual(nonce, this.lastNonce)) {
                        throw new IllegalArgumentException("cannot reuse nonce for GCM encryption");
                    }
                    this.lastKey = Arrays.clone(key);
                    this.lastNonce = Arrays.clone(nonce);
                    break block9;
                }
                throw new IllegalArgumentException("invalid parameters passed to GCM");
            }
            catch (Exception e) {
                throw PacketCipherException.from(e);
            }
        }
        int outLen = output != null ? output.length - outOff : 0;
        try {
            result = AESNativeGCMPacketCipher.processPacket(encryption, key, nonce, initialAssociatedText, macSize, input, inOff, len, output, outOff, outLen);
        }
        catch (Exception e) {
            throw PacketCipherException.from(e);
        }
        return result;
    }

    static native int getOutputSize(boolean var0, int var1, int var2);

    static native int processPacket(boolean var0, byte[] var1, byte[] var2, byte[] var3, int var4, byte[] var5, int var6, int var7, byte[] var8, int var9, int var10);

    public String toString() {
        return "GCM-PS[Native](AES[Native])";
    }

    @Override
    public void destroy() throws DestroyFailedException {
        Arrays.clear(this.lastKey);
        Arrays.clear(this.lastNonce);
        this.lastKey = null;
        this.lastNonce = null;
        this.destroyed = true;
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }
}

