/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto;

import java.util.Collections;
import java.util.Set;
import java.util.TreeSet;
import org.bouncycastle.crypto.NativeFeatures;
import org.bouncycastle.crypto.NativeLibIdentity;
import org.bouncycastle.crypto.NativeLoader;
import org.bouncycastle.crypto.NativeServices;
import org.bouncycastle.crypto.VariantSelector;

class DefaultNativeServices
implements NativeServices {
    private static Set<String> nativeFeatures = null;

    DefaultNativeServices() {
    }

    @Override
    public String getStatusMessage() {
        if (NativeLoader.isNativeLibsAvailableForSystem()) {
            if (NativeLoader.isNativeInstalled()) {
                return "READY";
            }
            return NativeLoader.getNativeStatusMessage();
        }
        return "UNSUPPORTED";
    }

    @Override
    public Set<String> getFeatureSet() {
        return DefaultNativeServices.getNativeFeatureSet();
    }

    @Override
    public String getVariant() {
        return NativeLoader.getSelectedVariant();
    }

    @Override
    public String[][] getVariantSelectionMatrix() {
        return VariantSelector.getFeatureMatrix();
    }

    @Override
    public boolean hasService(String feature) {
        if (nativeFeatures == null) {
            nativeFeatures = NativeLoader.isJavaSupportOnly() ? Collections.singleton("NONE") : DefaultNativeServices.getNativeFeatureSet();
        }
        return nativeFeatures.contains(feature);
    }

    @Override
    public String getBuildDate() {
        return NativeLibIdentity.getNativeBuiltTimeStamp();
    }

    @Override
    public String getLibraryIdent() {
        return NativeLibIdentity.getLibraryIdent();
    }

    @Override
    public boolean isEnabled() {
        return NativeLoader.isNativeAvailable();
    }

    @Override
    public boolean isInstalled() {
        return NativeLoader.isNativeInstalled();
    }

    @Override
    public boolean isSupported() {
        return NativeLoader.isNativeLibsAvailableForSystem();
    }

    static Set<String> getNativeFeatureSet() {
        TreeSet<String> set = new TreeSet<String>();
        if (!NativeLoader.isJavaSupportOnly()) {
            if (NativeFeatures.hasHardwareSeed()) {
                set.add("NRBG");
            }
            if (NativeFeatures.hasHardwareRand()) {
                set.add("DRBG");
            }
            if (NativeFeatures.hasAESHardwareSupport()) {
                set.add("AES/ECB");
            }
            if (NativeFeatures.hasGCMHardwareSupport()) {
                set.add("AES/GCM");
            }
            if (NativeFeatures.hasGCMSIVHardwareSupport()) {
                set.add("AES/GCM-SIV");
            }
            if (NativeFeatures.hasCBCHardwareSupport()) {
                set.add("AES/CBC");
            }
            if (NativeFeatures.hasCFBHardwareSupport()) {
                set.add("AES/CFB");
            }
            if (NativeFeatures.hasCTRHardwareSupport()) {
                set.add("AES/CTR");
            }
            if (NativeFeatures.hasHardwareSHA256()) {
                set.add("SHA2");
                set.add("SHA256");
            }
            if (NativeFeatures.hasHardwareSHA224()) {
                set.add("SHA224");
            }
            if (NativeFeatures.hasHardwareSHA384()) {
                set.add("SHA384");
            }
            if (NativeFeatures.hasHardwareSHA512()) {
                set.add("SHA512");
            }
            if (NativeFeatures.hasHardwareSHA512()) {
                set.add("SHA512");
            }
            if (NativeFeatures.hasCCMHardwareSupport()) {
                set.add("AES/CCM");
            }
            if (NativeFeatures.hasCBCPCHardwareSupport()) {
                set.add("AES/CBC-PC");
            }
            if (NativeFeatures.hasCCMPCHardwareSupport()) {
                set.add("AES/CCM-PC");
            }
            if (NativeFeatures.hasCFBPCHardwareSupport()) {
                set.add("AES/CFB-PC");
            }
            if (NativeFeatures.hasCTRPCHardwareSupport()) {
                set.add("AES/CTR-PC");
            }
            if (NativeFeatures.hasGCMPCHardwareSupport()) {
                set.add("AES/GCM-PC");
            }
            if (NativeFeatures.hasGCMSIVPCHardwareSupport()) {
                set.add("AES/GCMSIV-PC");
            }
            if (NativeFeatures.hasMultiplyAcc()) {
                set.add("MULACC");
            }
            if (NativeFeatures.hasSHA3()) {
                set.add("SHA3");
            }
            if (NativeFeatures.hasSHAKE()) {
                set.add("SHAKE");
            }
        }
        if (set.isEmpty()) {
            set.add("NONE");
        }
        return Collections.unmodifiableSet(set);
    }
}

