/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.UserDataPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.Strings;

public class UserIDPacket
extends ContainedPacket
implements UserDataPacket {
    private byte[] idData;

    public UserIDPacket(BCPGInputStream in) throws IOException {
        super(13);
        this.idData = in.readAll();
    }

    public UserIDPacket(String id) {
        super(13);
        this.idData = Strings.toUTF8ByteArray(id);
    }

    public UserIDPacket(byte[] rawID) {
        super(13);
        this.idData = Arrays.clone(rawID);
    }

    public String getID() {
        return Strings.fromUTF8ByteArray(this.idData);
    }

    public byte[] getRawID() {
        return Arrays.clone(this.idData);
    }

    public boolean equals(Object o) {
        if (o instanceof UserIDPacket) {
            return Arrays.areEqual(this.idData, ((UserIDPacket)o).idData);
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.idData);
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(13, this.idData);
    }
}

