/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.math.BigInteger;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.MPInteger;
import org.bouncycastle.util.BigIntegers;

public class RSASecretBCPGKey
extends BCPGObject
implements BCPGKey {
    MPInteger d;
    MPInteger p;
    MPInteger q;
    MPInteger u;
    BigInteger expP;
    BigInteger expQ;
    BigInteger crt;

    public RSASecretBCPGKey(BCPGInputStream in) throws IOException {
        this.d = new MPInteger(in);
        this.p = new MPInteger(in);
        this.q = new MPInteger(in);
        this.u = new MPInteger(in);
        this.expP = this.d.getValue().remainder(this.p.getValue().subtract(BigInteger.valueOf(1L)));
        this.expQ = this.d.getValue().remainder(this.q.getValue().subtract(BigInteger.valueOf(1L)));
        this.crt = BigIntegers.modOddInverse(this.p.getValue(), this.q.getValue());
    }

    public RSASecretBCPGKey(BigInteger d, BigInteger p, BigInteger q) {
        int cmp = p.compareTo(q);
        if (cmp >= 0) {
            if (cmp == 0) {
                throw new IllegalArgumentException("p and q cannot be equal");
            }
            BigInteger tmp = p;
            p = q;
            q = tmp;
        }
        this.d = new MPInteger(d);
        this.p = new MPInteger(p);
        this.q = new MPInteger(q);
        this.u = new MPInteger(BigIntegers.modOddInverse(q, p));
        this.expP = d.remainder(p.subtract(BigInteger.valueOf(1L)));
        this.expQ = d.remainder(q.subtract(BigInteger.valueOf(1L)));
        this.crt = BigIntegers.modOddInverse(p, q);
    }

    public BigInteger getModulus() {
        return this.p.getValue().multiply(this.q.getValue());
    }

    public BigInteger getPrivateExponent() {
        return this.d.getValue();
    }

    public BigInteger getPrimeP() {
        return this.p.getValue();
    }

    public BigInteger getPrimeQ() {
        return this.q.getValue();
    }

    public BigInteger getPrimeExponentP() {
        return this.expP;
    }

    public BigInteger getPrimeExponentQ() {
        return this.expQ;
    }

    public BigInteger getCrtCoefficient() {
        return this.crt;
    }

    @Override
    public String getFormat() {
        return "PGP";
    }

    @Override
    public byte[] getEncoded() {
        try {
            return super.getEncoded();
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writeObject(this.d);
        out.writeObject(this.p);
        out.writeObject(this.q);
        out.writeObject(this.u);
    }
}

