/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.bcpg.FastCRC24;
import org.bouncycastle.util.Strings;

public class ArmoredOutputStream
extends OutputStream {
    public static final String VERSION_HDR = "Version";
    public static final String COMMENT_HDR = "Comment";
    public static final String MESSAGE_ID_HDR = "MessageID";
    public static final String HASH_HDR = "Hash";
    public static final String CHARSET_HDR = "Charset";
    public static final String DEFAULT_VERSION = "BCPG v@RELEASE_NAME@";
    private static final byte[] encodingTable = new byte[]{65, 66, 67, 68, 69, 70, 71, 72, 73, 74, 75, 76, 77, 78, 79, 80, 81, 82, 83, 84, 85, 86, 87, 88, 89, 90, 97, 98, 99, 100, 101, 102, 103, 104, 105, 106, 107, 108, 109, 110, 111, 112, 113, 114, 115, 116, 117, 118, 119, 120, 121, 122, 48, 49, 50, 51, 52, 53, 54, 55, 56, 57, 43, 47};
    OutputStream out;
    byte[] buf = new byte[3];
    int bufPtr = 0;
    CRC24 crc = new FastCRC24();
    int chunkCount = 0;
    int lastb;
    boolean start = true;
    boolean clearText = false;
    boolean newLine = false;
    String nl = Strings.lineSeparator();
    String type;
    String headerStart = "-----BEGIN PGP ";
    String headerTail = "-----";
    String footerStart = "-----END PGP ";
    String footerTail = "-----";
    final Hashtable<String, List<String>> headers = new Hashtable();

    private static void encode(OutputStream out, byte[] data, int len) throws IOException {
        switch (len) {
            case 1: {
                int d1 = data[0] & 0xFF;
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[d1 << 4 & 0x3F]);
                out.write(61);
                out.write(61);
                break;
            }
            case 2: {
                int d1 = data[0] & 0xFF;
                int d2 = data[1] & 0xFF;
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[(d1 << 4 | d2 >>> 4) & 0x3F]);
                out.write(encodingTable[d2 << 2 & 0x3F]);
                out.write(61);
                break;
            }
            case 3: {
                int d1 = data[0] & 0xFF;
                int d2 = data[1] & 0xFF;
                int d3 = data[2] & 0xFF;
                out.write(encodingTable[d1 >>> 2 & 0x3F]);
                out.write(encodingTable[(d1 << 4 | d2 >>> 4) & 0x3F]);
                out.write(encodingTable[(d2 << 2 | d3 >>> 6) & 0x3F]);
                out.write(encodingTable[d3 & 0x3F]);
                break;
            }
            default: {
                throw new IOException("unknown length in encode");
            }
        }
    }

    private static void encode3(OutputStream out, byte[] data) throws IOException {
        int d1 = data[0] & 0xFF;
        int d2 = data[1] & 0xFF;
        int d3 = data[2] & 0xFF;
        out.write(encodingTable[d1 >>> 2 & 0x3F]);
        out.write(encodingTable[(d1 << 4 | d2 >>> 4) & 0x3F]);
        out.write(encodingTable[(d2 << 2 | d3 >>> 6) & 0x3F]);
        out.write(encodingTable[d3 & 0x3F]);
    }

    public ArmoredOutputStream(OutputStream out) {
        this.out = out;
        if (this.nl == null) {
            this.nl = "\r\n";
        }
        this.setHeader(VERSION_HDR, DEFAULT_VERSION);
    }

    public ArmoredOutputStream(OutputStream out, Hashtable<String, String> headers) {
        this(out);
        Enumeration<String> e = headers.keys();
        while (e.hasMoreElements()) {
            String key = e.nextElement();
            ArrayList<String> headerList = new ArrayList<String>();
            headerList.add(headers.get(key));
            this.headers.put(key, headerList);
        }
    }

    ArmoredOutputStream(OutputStream out, Builder builder) {
        this(out);
        if (!builder.computeCRCSum) {
            this.crc = null;
        }
        this.headers.clear();
        Map headerMap = builder.headers;
        for (String key : headerMap.keySet()) {
            this.headers.put(key, (List<String>)headerMap.get(key));
        }
    }

    @Deprecated
    public void setHeader(String name, String value) {
        if (value == null) {
            this.headers.remove(name);
        } else {
            List<String> valueList = this.headers.get(name);
            if (valueList == null) {
                valueList = new ArrayList<String>();
                this.headers.put(name, valueList);
            } else {
                valueList.clear();
            }
            valueList.add(value);
        }
    }

    @Deprecated
    public void clearHeaders() {
        this.headers.clear();
    }

    @Deprecated
    public void addHeader(String name, String value) {
        if (value == null || name == null) {
            return;
        }
        List<String> valueList = this.headers.get(name);
        if (valueList == null) {
            valueList = new ArrayList<String>();
            this.headers.put(name, valueList);
        }
        valueList.add(value);
    }

    @Deprecated
    public void resetHeaders() {
        List<String> versions = this.headers.get(VERSION_HDR);
        this.headers.clear();
        if (versions != null) {
            this.headers.put(VERSION_HDR, versions);
        }
    }

    public void beginClearText(int hashAlgorithm) throws IOException {
        this.beginClearText(new int[]{hashAlgorithm});
    }

    public void beginClearText(int ... hashAlgorithms) throws IOException {
        StringBuilder sb = new StringBuilder("-----BEGIN PGP SIGNED MESSAGE-----");
        sb.append(this.nl);
        for (int hashAlgorithm : hashAlgorithms) {
            String hash;
            switch (hashAlgorithm) {
                case 1: {
                    hash = "MD5";
                    break;
                }
                case 2: {
                    hash = "SHA1";
                    break;
                }
                case 3: {
                    hash = "RIPEMD160";
                    break;
                }
                case 5: {
                    hash = "MD2";
                    break;
                }
                case 8: {
                    hash = "SHA256";
                    break;
                }
                case 9: {
                    hash = "SHA384";
                    break;
                }
                case 10: {
                    hash = "SHA512";
                    break;
                }
                case 11: {
                    hash = "SHA224";
                    break;
                }
                case 12: 
                case 313: {
                    hash = "SHA3-256";
                    break;
                }
                case 314: {
                    hash = "SHA3-384";
                    break;
                }
                case 14: 
                case 315: {
                    hash = "SHA3-512";
                    break;
                }
                case 312: {
                    hash = "SHA3-224";
                    break;
                }
                default: {
                    throw new IOException("unknown hash algorithm tag in beginClearText: " + hashAlgorithm);
                }
            }
            sb.append(HASH_HDR).append(": ").append(hash).append(this.nl);
        }
        sb.append(this.nl);
        this.write(sb.toString());
        this.clearText = true;
        this.newLine = true;
        this.lastb = 0;
    }

    public void endClearText() {
        this.clearText = false;
    }

    private void writeHeaderEntry(String name, String value) throws IOException {
        this.write(name);
        this.write(": ");
        this.write(value);
        this.write(this.nl);
    }

    @Override
    public void write(int b) throws IOException {
        if (this.clearText) {
            this.out.write(b);
            if (this.newLine) {
                if (b != 10 || this.lastb != 13) {
                    this.newLine = false;
                }
                if (b == 45) {
                    this.out.write(32);
                    this.out.write(45);
                }
            }
            if (b == 13 || b == 10 && this.lastb != 13) {
                this.newLine = true;
            }
            this.lastb = b;
            return;
        }
        if (this.start) {
            boolean newPacket = (b & 0x40) != 0;
            int tag = 0;
            tag = newPacket ? b & 0x3F : (b & 0x3F) >> 2;
            switch (tag) {
                case 6: {
                    this.type = "PUBLIC KEY BLOCK";
                    break;
                }
                case 5: {
                    this.type = "PRIVATE KEY BLOCK";
                    break;
                }
                case 2: {
                    this.type = "SIGNATURE";
                    break;
                }
                default: {
                    this.type = "MESSAGE";
                }
            }
            this.write(this.headerStart);
            this.write(this.type);
            this.write(this.headerTail);
            this.write(this.nl);
            if (this.headers.containsKey(VERSION_HDR)) {
                this.writeHeaderEntry(VERSION_HDR, this.headers.get(VERSION_HDR).get(0));
            }
            Enumeration<String> e = this.headers.keys();
            while (e.hasMoreElements()) {
                String key = e.nextElement();
                if (key.equals(VERSION_HDR)) continue;
                List<String> values = this.headers.get(key);
                Iterator<String> it = values.iterator();
                while (it.hasNext()) {
                    this.writeHeaderEntry(key, it.next());
                }
            }
            this.write(this.nl);
            this.start = false;
        }
        if (this.bufPtr == 3) {
            if (this.crc != null) {
                this.crc.update3(this.buf, 0);
            }
            ArmoredOutputStream.encode3(this.out, this.buf);
            this.bufPtr = 0;
            if ((++this.chunkCount & 0xF) == 0) {
                this.write(this.nl);
            }
        }
        this.buf[this.bufPtr++] = (byte)b;
    }

    @Override
    public void flush() throws IOException {
    }

    @Override
    public void close() throws IOException {
        if (this.type != null) {
            if (this.bufPtr > 0) {
                if (this.crc != null) {
                    for (int i = 0; i < this.bufPtr; ++i) {
                        this.crc.update(this.buf[i] & 0xFF);
                    }
                }
                ArmoredOutputStream.encode(this.out, this.buf, this.bufPtr);
            }
            this.write(this.nl);
            if (this.crc != null) {
                this.out.write(61);
                int crcV = this.crc.getValue();
                this.buf[0] = (byte)(crcV >>> 16);
                this.buf[1] = (byte)(crcV >>> 8);
                this.buf[2] = (byte)crcV;
                ArmoredOutputStream.encode3(this.out, this.buf);
                this.write(this.nl);
            }
            this.write(this.footerStart);
            this.write(this.type);
            this.write(this.footerTail);
            this.write(this.nl);
            this.out.flush();
            this.type = null;
            this.start = true;
        }
    }

    private void write(String string) throws IOException {
        this.out.write(Strings.toUTF8ByteArray(string));
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private final Map<String, List<String>> headers = new HashMap<String, List<String>>();
        private boolean computeCRCSum = true;

        private Builder() {
        }

        public ArmoredOutputStream build(OutputStream outputStream) {
            return new ArmoredOutputStream(outputStream, this);
        }

        public Builder setVersion(String version) {
            return this.setSingletonHeader(ArmoredOutputStream.VERSION_HDR, version);
        }

        public Builder setComment(String comment) {
            return this.replaceHeader(ArmoredOutputStream.COMMENT_HDR, comment);
        }

        public Builder setMessageId(String messageId) {
            return this.replaceHeader(ArmoredOutputStream.MESSAGE_ID_HDR, messageId);
        }

        public Builder setCharset(String charset) {
            return this.replaceHeader(ArmoredOutputStream.CHARSET_HDR, charset);
        }

        public Builder addComment(String comment) {
            return this.addHeader(ArmoredOutputStream.COMMENT_HDR, comment);
        }

        private Builder setSingletonHeader(String key, String value) {
            if (value == null || value.trim().isEmpty()) {
                this.headers.remove(key);
            } else {
                String trimmed = value.trim();
                if (trimmed.contains("\n")) {
                    throw new IllegalArgumentException("Armor header value for key " + key + " cannot contain newlines.");
                }
                this.headers.put(key, Collections.singletonList(value));
            }
            return this;
        }

        private Builder addHeader(String key, String value) {
            if (value == null || value.trim().isEmpty()) {
                return this;
            }
            List<String> values = this.headers.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                this.headers.put(key, values);
            }
            String trimmed = value.trim();
            for (String line : trimmed.split("\n")) {
                if (line.trim().isEmpty()) continue;
                values.add(line.trim());
            }
            return this;
        }

        private Builder replaceHeader(String key, String value) {
            if (value == null || value.trim().isEmpty()) {
                return this;
            }
            ArrayList<String> values = new ArrayList<String>();
            String trimmed = value.trim();
            for (String line : trimmed.split("\n")) {
                if (line.trim().isEmpty()) continue;
                values.add(line.trim());
            }
            this.headers.put(key, values);
            return this;
        }

        public Builder clearHeaders() {
            this.headers.clear();
            return this;
        }

        public Builder enableCRC(boolean doComputeCRC) {
            this.computeCRCSum = doComputeCRC;
            return this;
        }
    }
}

