/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.io.InputStream;
import java.math.BigInteger;
import org.bouncycastle.asn1.ASN1ObjectIdentifier;
import org.bouncycastle.asn1.x9.ECNamedCurveTable;
import org.bouncycastle.asn1.x9.X9ECParameters;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.BufferedBlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.DefaultBufferedBlockCipher;
import org.bouncycastle.crypto.ec.CustomNamedCurves;
import org.bouncycastle.crypto.io.CipherInputStream;
import org.bouncycastle.crypto.modes.CFBBlockCipher;
import org.bouncycastle.crypto.modes.OpenPGPCFBBlockCipher;
import org.bouncycastle.crypto.params.KeyParameter;
import org.bouncycastle.crypto.params.ParametersWithIV;
import org.bouncycastle.math.ec.ECCurve;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;
import org.bouncycastle.util.BigIntegers;

public class BcUtil {
    static BufferedBlockCipher createStreamCipher(boolean forEncryption, BlockCipher engine, boolean withIntegrityPacket, byte[] key) {
        DefaultBufferedBlockCipher c = withIntegrityPacket ? new DefaultBufferedBlockCipher((BlockCipher)CFBBlockCipher.newInstance((BlockCipher)engine, (int)(engine.getBlockSize() * 8))) : new DefaultBufferedBlockCipher((BlockCipher)new OpenPGPCFBBlockCipher(engine));
        KeyParameter keyParameter = new KeyParameter(key);
        if (withIntegrityPacket) {
            c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)keyParameter, new byte[engine.getBlockSize()]));
        } else {
            c.init(forEncryption, (CipherParameters)keyParameter);
        }
        return c;
    }

    public static PGPDataDecryptor createDataDecryptor(boolean withIntegrityPacket, BlockCipher engine, byte[] key) {
        final BufferedBlockCipher c = BcUtil.createStreamCipher(false, engine, withIntegrityPacket, key);
        return new PGPDataDecryptor(){

            @Override
            public InputStream getInputStream(InputStream in) {
                return new CipherInputStream(in, c);
            }

            @Override
            public int getBlockSize() {
                return c.getBlockSize();
            }

            @Override
            public PGPDigestCalculator getIntegrityCalculator() {
                return new SHA1PGPDigestCalculator();
            }
        };
    }

    public static DefaultBufferedBlockCipher createSymmetricKeyWrapper(boolean forEncryption, BlockCipher engine, byte[] key, byte[] iv) {
        DefaultBufferedBlockCipher c = new DefaultBufferedBlockCipher((BlockCipher)CFBBlockCipher.newInstance((BlockCipher)engine, (int)(engine.getBlockSize() * 8)));
        c.init(forEncryption, (CipherParameters)new ParametersWithIV((CipherParameters)new KeyParameter(key), iv));
        return c;
    }

    static X9ECParameters getX9Parameters(ASN1ObjectIdentifier curveOID) {
        X9ECParameters x9 = CustomNamedCurves.getByOID((ASN1ObjectIdentifier)curveOID);
        if (x9 == null) {
            x9 = ECNamedCurveTable.getByOID((ASN1ObjectIdentifier)curveOID);
        }
        return x9;
    }

    static ECPoint decodePoint(BigInteger encodedPoint, ECCurve curve) {
        return curve.decodePoint(BigIntegers.asUnsignedByteArray((BigInteger)encodedPoint));
    }
}

