/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox.bc;

import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.gpg.keybox.BlobVerifier;
import org.bouncycastle.util.Arrays;

public class BcBlobVerifier
implements BlobVerifier {
    private final SHA1Digest sha1Digest = new SHA1Digest();
    private final MD5Digest md5Digest = new MD5Digest();

    @Override
    public boolean isMatched(byte[] blobData, byte[] blobDigest) {
        this.sha1Digest.update(blobData, 0, blobData.length);
        byte[] calculatedDigest = new byte[this.sha1Digest.getDigestSize()];
        this.sha1Digest.doFinal(calculatedDigest, 0);
        if (!Arrays.constantTimeAreEqual((byte[])calculatedDigest, (byte[])blobDigest)) {
            if (blobDigest[0] == 0 && blobDigest[1] == 0 && blobDigest[2] == 0 && blobDigest[3] == 0) {
                this.md5Digest.update(blobData, 0, blobData.length);
                Arrays.fill((byte[])calculatedDigest, (byte)0);
                this.md5Digest.doFinal(calculatedDigest, 4);
                return Arrays.constantTimeAreEqual((byte[])calculatedDigest, (byte[])blobDigest);
            }
            return false;
        }
        return true;
    }
}

