/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.AsymmetricBlockCipher;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.CipherParameters;
import org.bouncycastle.crypto.CryptoException;
import org.bouncycastle.crypto.DSA;
import org.bouncycastle.crypto.DataLengthException;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.MultiBlockCipher;
import org.bouncycastle.crypto.Signer;
import org.bouncycastle.crypto.Wrapper;
import org.bouncycastle.crypto.digests.MD2Digest;
import org.bouncycastle.crypto.digests.MD5Digest;
import org.bouncycastle.crypto.digests.RIPEMD160Digest;
import org.bouncycastle.crypto.digests.SHA1Digest;
import org.bouncycastle.crypto.digests.SHA224Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.digests.SHA384Digest;
import org.bouncycastle.crypto.digests.SHA3Digest;
import org.bouncycastle.crypto.digests.SHA512Digest;
import org.bouncycastle.crypto.digests.TigerDigest;
import org.bouncycastle.crypto.encodings.PKCS1Encoding;
import org.bouncycastle.crypto.engines.AESEngine;
import org.bouncycastle.crypto.engines.BlowfishEngine;
import org.bouncycastle.crypto.engines.CAST5Engine;
import org.bouncycastle.crypto.engines.CamelliaEngine;
import org.bouncycastle.crypto.engines.DESEngine;
import org.bouncycastle.crypto.engines.DESedeEngine;
import org.bouncycastle.crypto.engines.ElGamalEngine;
import org.bouncycastle.crypto.engines.IDEAEngine;
import org.bouncycastle.crypto.engines.RFC3394WrapEngine;
import org.bouncycastle.crypto.engines.RSABlindedEngine;
import org.bouncycastle.crypto.engines.TwofishEngine;
import org.bouncycastle.crypto.params.Ed25519PrivateKeyParameters;
import org.bouncycastle.crypto.params.Ed25519PublicKeyParameters;
import org.bouncycastle.crypto.signers.DSADigestSigner;
import org.bouncycastle.crypto.signers.DSASigner;
import org.bouncycastle.crypto.signers.ECDSASigner;
import org.bouncycastle.crypto.signers.Ed25519Signer;
import org.bouncycastle.crypto.signers.Ed448Signer;
import org.bouncycastle.crypto.signers.RSADigestSigner;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.util.Arrays;

class BcImplProvider {
    BcImplProvider() {
    }

    static Digest createDigest(int algorithm) throws PGPException {
        switch (algorithm) {
            case 2: {
                return new SHA1Digest();
            }
            case 11: {
                return new SHA224Digest();
            }
            case 8: {
                return new SHA256Digest();
            }
            case 9: {
                return new SHA384Digest();
            }
            case 10: {
                return new SHA512Digest();
            }
            case 312: {
                return new SHA3Digest(224);
            }
            case 12: 
            case 313: {
                return new SHA3Digest(256);
            }
            case 314: {
                return new SHA3Digest(384);
            }
            case 14: 
            case 315: {
                return new SHA3Digest(512);
            }
            case 5: {
                return new MD2Digest();
            }
            case 1: {
                return new MD5Digest();
            }
            case 3: {
                return new RIPEMD160Digest();
            }
            case 6: {
                return new TigerDigest();
            }
        }
        throw new PGPException("cannot recognise digest");
    }

    static Signer createSigner(int keyAlgorithm, int hashAlgorithm, CipherParameters keyParam) throws PGPException {
        switch (keyAlgorithm) {
            case 1: 
            case 3: {
                return new RSADigestSigner(BcImplProvider.createDigest(hashAlgorithm));
            }
            case 17: {
                return new DSADigestSigner((DSA)new DSASigner(), BcImplProvider.createDigest(hashAlgorithm));
            }
            case 19: {
                return new DSADigestSigner((DSA)new ECDSASigner(), BcImplProvider.createDigest(hashAlgorithm));
            }
            case 22: {
                if (keyParam instanceof Ed25519PrivateKeyParameters || keyParam instanceof Ed25519PublicKeyParameters) {
                    return new EdDsaSigner((Signer)new Ed25519Signer(), BcImplProvider.createDigest(hashAlgorithm));
                }
                return new EdDsaSigner((Signer)new Ed448Signer(new byte[0]), BcImplProvider.createDigest(hashAlgorithm));
            }
        }
        throw new PGPException("cannot recognise keyAlgorithm: " + keyAlgorithm);
    }

    static BlockCipher createBlockCipher(int encAlgorithm) throws PGPException {
        MultiBlockCipher engine;
        switch (encAlgorithm) {
            case 7: 
            case 8: 
            case 9: {
                engine = AESEngine.newInstance();
                break;
            }
            case 11: 
            case 12: 
            case 13: {
                engine = new CamelliaEngine();
                break;
            }
            case 4: {
                engine = new BlowfishEngine();
                break;
            }
            case 3: {
                engine = new CAST5Engine();
                break;
            }
            case 6: {
                engine = new DESEngine();
                break;
            }
            case 1: {
                engine = new IDEAEngine();
                break;
            }
            case 10: {
                engine = new TwofishEngine();
                break;
            }
            case 2: {
                engine = new DESedeEngine();
                break;
            }
            default: {
                throw new PGPException("cannot recognise cipher");
            }
        }
        return engine;
    }

    static Wrapper createWrapper(int encAlgorithm) throws PGPException {
        switch (encAlgorithm) {
            case 7: 
            case 8: 
            case 9: {
                return new RFC3394WrapEngine((BlockCipher)AESEngine.newInstance());
            }
            case 11: 
            case 12: 
            case 13: {
                return new RFC3394WrapEngine((BlockCipher)new CamelliaEngine());
            }
        }
        throw new PGPException("unknown wrap algorithm: " + encAlgorithm);
    }

    static AsymmetricBlockCipher createPublicKeyCipher(int encAlgorithm) throws PGPException {
        PKCS1Encoding c;
        switch (encAlgorithm) {
            case 1: 
            case 2: {
                c = new PKCS1Encoding((AsymmetricBlockCipher)new RSABlindedEngine());
                break;
            }
            case 16: 
            case 20: {
                c = new PKCS1Encoding((AsymmetricBlockCipher)new ElGamalEngine());
                break;
            }
            case 17: {
                throw new PGPException("Can't use DSA for encryption.");
            }
            case 19: {
                throw new PGPException("Can't use ECDSA for encryption.");
            }
            case 18: {
                throw new PGPException("Not implemented.");
            }
            default: {
                throw new PGPException("unknown asymmetric algorithm: " + encAlgorithm);
            }
        }
        return c;
    }

    private static class EdDsaSigner
    implements Signer {
        private final Signer signer;
        private final Digest digest;
        private final byte[] digBuf;

        EdDsaSigner(Signer signer, Digest digest) {
            this.signer = signer;
            this.digest = digest;
            this.digBuf = new byte[digest.getDigestSize()];
        }

        public void init(boolean forSigning, CipherParameters param) {
            this.signer.init(forSigning, param);
            this.digest.reset();
        }

        public void update(byte b) {
            this.digest.update(b);
        }

        public void update(byte[] in, int off, int len) {
            this.digest.update(in, off, len);
        }

        public byte[] generateSignature() throws CryptoException, DataLengthException {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.generateSignature();
        }

        public boolean verifySignature(byte[] signature) {
            this.digest.doFinal(this.digBuf, 0);
            this.signer.update(this.digBuf, 0, this.digBuf.length);
            return this.signer.verifySignature(signature);
        }

        public void reset() {
            Arrays.clear((byte[])this.digBuf);
            this.signer.reset();
            this.digest.reset();
        }
    }
}

