/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.gpg.keybox;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;

class KeyBoxByteBuffer {
    private final ByteBuffer buffer;

    public KeyBoxByteBuffer(ByteBuffer buffer) {
        this.buffer = buffer;
    }

    static KeyBoxByteBuffer wrap(Object src) throws IOException {
        if (src == null) {
            return null;
        }
        if (src instanceof KeyBoxByteBuffer) {
            return (KeyBoxByteBuffer)src;
        }
        if (src instanceof ByteBuffer) {
            return new KeyBoxByteBuffer((ByteBuffer)src);
        }
        if (src instanceof byte[]) {
            return KeyBoxByteBuffer.wrap(ByteBuffer.wrap((byte[])src));
        }
        if (src instanceof ByteArrayOutputStream) {
            return KeyBoxByteBuffer.wrap(((ByteArrayOutputStream)src).toByteArray());
        }
        if (src instanceof InputStream) {
            int i;
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            byte[] buf = new byte[4096];
            while ((i = ((InputStream)src).read(buf)) >= 0) {
                bos.write(buf, 0, i);
            }
            bos.flush();
            bos.close();
            return KeyBoxByteBuffer.wrap(bos);
        }
        throw new IllegalStateException("Could not convert " + src.getClass().getCanonicalName() + " to KeyBoxByteBuffer");
    }

    public int size() {
        return this.buffer.limit() - 20;
    }

    public byte[] rangeOf(int start, int end) {
        if (end - start < 0 || start < 0) {
            throw new IllegalArgumentException("invalid range " + start + ":" + end);
        }
        if (end > this.buffer.limit()) {
            throw new IllegalArgumentException("range exceeds buffer remaining");
        }
        int p = this.buffer.position();
        this.buffer.position(start);
        byte[] data = new byte[end - start];
        this.buffer.get(data);
        this.buffer.position(p);
        return data;
    }

    public boolean hasRemaining() {
        return this.buffer.hasRemaining();
    }

    public int remaining() {
        return this.buffer.remaining();
    }

    public int position() {
        return this.buffer.position();
    }

    public void position(int p) {
        this.buffer.position(p);
    }

    public int u16() {
        return this.u8() << 8 | this.u8();
    }

    public long u32() {
        return this.u8() << 24 | this.u8() << 16 | this.u8() << 8 | this.u8();
    }

    public int u8() {
        return this.buffer.get() & 0xFF;
    }

    public void consume(int size) {
        if (size > this.remaining()) {
            throw new IllegalArgumentException("size exceeds buffer remaining");
        }
        while (--size >= 0) {
            this.buffer.get();
        }
    }

    public byte[] bN(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("size less than 0");
        }
        if (size > this.remaining()) {
            throw new IllegalArgumentException("size exceeds buffer remaining");
        }
        byte[] b = new byte[size];
        this.buffer.get(b);
        return b;
    }

    public ByteBuffer getBuffer() {
        return this.buffer;
    }
}

