/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Date;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGKey;
import org.bouncycastle.bcpg.BCPGObject;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.bcpg.DSAPublicBCPGKey;
import org.bouncycastle.bcpg.ECDHPublicBCPGKey;
import org.bouncycastle.bcpg.ECDSAPublicBCPGKey;
import org.bouncycastle.bcpg.Ed25519PublicBCPGKey;
import org.bouncycastle.bcpg.Ed448PublicBCPGKey;
import org.bouncycastle.bcpg.EdDSAPublicBCPGKey;
import org.bouncycastle.bcpg.ElGamalPublicBCPGKey;
import org.bouncycastle.bcpg.PublicKeyAlgorithmTags;
import org.bouncycastle.bcpg.RSAPublicBCPGKey;
import org.bouncycastle.bcpg.X25519PublicBCPGKey;
import org.bouncycastle.bcpg.X448PublicBCPGKey;

public class PublicKeyPacket
extends ContainedPacket
implements PublicKeyAlgorithmTags {
    public static final int VERSION_3 = 3;
    public static final int VERSION_4 = 4;
    public static final int VERSION_6 = 6;
    private int version;
    private long time;
    private int validDays;
    private int algorithm;
    private BCPGKey key;

    PublicKeyPacket(BCPGInputStream in) throws IOException {
        this.version = in.read();
        this.time = (long)in.read() << 24 | (long)(in.read() << 16) | (long)(in.read() << 8) | (long)in.read();
        if (this.version <= 3) {
            this.validDays = in.read() << 8 | in.read();
        }
        this.algorithm = (byte)in.read();
        if (this.version == 6) {
            long l = (long)in.read() << 24 | (long)in.read() << 16 | (long)in.read() << 8 | (long)in.read();
        }
        switch (this.algorithm) {
            case 1: 
            case 2: 
            case 3: {
                this.key = new RSAPublicBCPGKey(in);
                break;
            }
            case 17: {
                this.key = new DSAPublicBCPGKey(in);
                break;
            }
            case 16: 
            case 20: {
                this.key = new ElGamalPublicBCPGKey(in);
                break;
            }
            case 18: {
                this.key = new ECDHPublicBCPGKey(in);
                break;
            }
            case 19: {
                this.key = new ECDSAPublicBCPGKey(in);
                break;
            }
            case 22: {
                this.key = new EdDSAPublicBCPGKey(in);
                break;
            }
            case 25: {
                this.key = new X25519PublicBCPGKey(in);
                break;
            }
            case 26: {
                this.key = new X448PublicBCPGKey(in);
                break;
            }
            case 27: {
                this.key = new Ed25519PublicBCPGKey(in);
                break;
            }
            case 28: {
                this.key = new Ed448PublicBCPGKey(in);
                break;
            }
            default: {
                throw new IOException("unknown PGP public key algorithm encountered: " + this.algorithm);
            }
        }
    }

    public PublicKeyPacket(int algorithm, Date time, BCPGKey key) {
        this.version = 4;
        this.time = time.getTime() / 1000L;
        this.algorithm = algorithm;
        this.key = key;
    }

    public int getVersion() {
        return this.version;
    }

    public int getAlgorithm() {
        return this.algorithm;
    }

    public int getValidDays() {
        return this.validDays;
    }

    public Date getTime() {
        return new Date(this.time * 1000L);
    }

    public BCPGKey getKey() {
        return this.key;
    }

    public byte[] getEncodedContents() throws IOException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        BCPGOutputStream pOut = new BCPGOutputStream(bOut);
        pOut.write(this.version);
        pOut.write((byte)(this.time >> 24));
        pOut.write((byte)(this.time >> 16));
        pOut.write((byte)(this.time >> 8));
        pOut.write((byte)this.time);
        if (this.version <= 3) {
            pOut.write((byte)(this.validDays >> 8));
            pOut.write((byte)this.validDays);
        }
        pOut.write(this.algorithm);
        if (this.version == 6) {
            int keyOctets = this.key.getEncoded().length;
            pOut.write(keyOctets >> 24);
            pOut.write(keyOctets >> 16);
            pOut.write(keyOctets >> 8);
            pOut.write(keyOctets);
        }
        pOut.writeObject((BCPGObject)((Object)this.key));
        pOut.close();
        return bOut.toByteArray();
    }

    @Override
    public void encode(BCPGOutputStream out) throws IOException {
        out.writePacket(6, this.getEncodedContents());
    }
}

