/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.BCPGOutputStream;
import org.bouncycastle.bcpg.ContainedPacket;
import org.bouncycastle.util.Arrays;
import org.bouncycastle.util.io.Streams;

public class PaddingPacket
extends ContainedPacket {
    private final byte[] padding;

    public PaddingPacket(BCPGInputStream in) throws IOException {
        this.padding = Streams.readAll((InputStream)in);
    }

    public PaddingPacket(byte[] padding) {
        this.padding = padding;
    }

    public PaddingPacket(int octetLen, SecureRandom random) {
        this(PaddingPacket.randomBytes(octetLen, random));
    }

    private static byte[] randomBytes(int octetCount, SecureRandom random) {
        byte[] bytes = new byte[octetCount];
        random.nextBytes(bytes);
        return bytes;
    }

    public byte[] getPadding() {
        return Arrays.clone((byte[])this.padding);
    }

    @Override
    public void encode(BCPGOutputStream pOut) throws IOException {
        pOut.writePacket(21, this.padding);
    }
}

