/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.bcpg;

import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import org.bouncycastle.bcpg.ArmoredInputException;
import org.bouncycastle.bcpg.CRC24;
import org.bouncycastle.bcpg.FastCRC24;
import org.bouncycastle.util.StringList;
import org.bouncycastle.util.Strings;

public class ArmoredInputStream
extends InputStream {
    private static final byte[] decodingTable;
    private boolean detectMissingChecksum = false;
    InputStream in;
    boolean start = true;
    byte[] outBuf = new byte[3];
    int bufPtr = 3;
    CRC24 crc = new FastCRC24();
    boolean crcFound = false;
    boolean hasHeaders = true;
    String header = null;
    boolean newLineFound = false;
    boolean clearText = false;
    boolean restart = false;
    StringList headerList = Strings.newList();
    int lastC = 0;
    boolean isEndOfStream;

    private static int decode(int in0, int in1, int in2, int in3, byte[] out) throws IOException {
        if (in3 < 0) {
            throw new EOFException("unexpected end of file in armored stream.");
        }
        if (in2 == 61) {
            int b1 = decodingTable[in0] & 0xFF;
            int b2 = decodingTable[in1] & 0xFF;
            if ((b1 | b2) < 0) {
                throw new ArmoredInputException("invalid armor");
            }
            out[2] = (byte)(b1 << 2 | b2 >> 4);
            return 2;
        }
        if (in3 == 61) {
            byte b1 = decodingTable[in0];
            byte b2 = decodingTable[in1];
            byte b3 = decodingTable[in2];
            if ((b1 | b2 | b3) < 0) {
                throw new ArmoredInputException("invalid armor");
            }
            out[1] = (byte)(b1 << 2 | b2 >> 4);
            out[2] = (byte)(b2 << 4 | b3 >> 2);
            return 1;
        }
        byte b1 = decodingTable[in0];
        byte b2 = decodingTable[in1];
        byte b3 = decodingTable[in2];
        byte b4 = decodingTable[in3];
        if ((b1 | b2 | b3 | b4) < 0) {
            throw new ArmoredInputException("invalid armor");
        }
        out[0] = (byte)(b1 << 2 | b2 >> 4);
        out[1] = (byte)(b2 << 4 | b3 >> 2);
        out[2] = (byte)(b3 << 6 | b4);
        return 0;
    }

    public ArmoredInputStream(InputStream in) throws IOException {
        this(in, true);
    }

    public ArmoredInputStream(InputStream in, boolean hasHeaders) throws IOException {
        this.in = in;
        this.hasHeaders = hasHeaders;
        if (hasHeaders) {
            this.parseHeaders();
        }
        this.start = false;
    }

    @Override
    public int available() throws IOException {
        return this.in.available();
    }

    private boolean parseHeaders() throws IOException {
        int c;
        this.header = null;
        int last = 0;
        boolean headerFound = false;
        this.headerList = Strings.newList();
        if (this.restart) {
            headerFound = true;
        } else {
            while ((c = this.in.read()) >= 0) {
                if (c == 45 && (last == 0 || last == 10 || last == 13)) {
                    headerFound = true;
                    break;
                }
                last = c;
            }
        }
        if (headerFound) {
            int nl;
            boolean eolReached = false;
            boolean crLf = false;
            ByteArrayOutputStream buf = new ByteArrayOutputStream();
            buf.write(45);
            if (this.restart) {
                buf.write(45);
            }
            while ((c = this.in.read()) >= 0) {
                if (last == 13 && c == 10) {
                    crLf = true;
                }
                if (eolReached && last != 13 && c == 10 || eolReached && c == 13) break;
                if (c == 13 || last != 13 && c == 10) {
                    String line = Strings.fromUTF8ByteArray((byte[])buf.toByteArray());
                    if (line.trim().length() == 0) break;
                    if (this.headerList.size() != 0 && line.indexOf(58) < 0) {
                        throw new ArmoredInputException("invalid armor header");
                    }
                    this.headerList.add(line);
                    buf.reset();
                }
                if (c != 10 && c != 13) {
                    buf.write(c);
                    eolReached = false;
                } else if (c == 13 || last != 13 && c == 10) {
                    eolReached = true;
                }
                last = c;
            }
            if (crLf && (nl = this.in.read()) != 10) {
                throw new ArmoredInputException("inconsistent line endings in headers");
            }
        }
        if (this.headerList.size() > 0) {
            this.header = this.headerList.get(0);
        }
        this.clearText = "-----BEGIN PGP SIGNED MESSAGE-----".equals(this.header);
        this.newLineFound = true;
        return headerFound;
    }

    public boolean isClearText() {
        return this.clearText;
    }

    public boolean isEndOfStream() {
        return this.isEndOfStream;
    }

    public String getArmorHeaderLine() {
        return this.header;
    }

    public String[] getArmorHeaders() {
        if (this.headerList.size() <= 1) {
            return null;
        }
        return this.headerList.toStringArray(1, this.headerList.size());
    }

    private int readIgnoreSpace() throws IOException {
        int c = this.in.read();
        while (c == 32 || c == 9 || c == 12 || c == 11) {
            c = this.in.read();
        }
        if (c >= 128) {
            throw new ArmoredInputException("invalid armor");
        }
        return c;
    }

    @Override
    public int read() throws IOException {
        if (this.start) {
            if (this.hasHeaders) {
                this.parseHeaders();
            }
            this.crc.reset();
            this.start = false;
        }
        if (this.clearText) {
            int c = this.in.read();
            if (c == 13 || c == 10 && this.lastC != 13) {
                this.newLineFound = true;
            } else if (this.newLineFound && c == 45) {
                c = this.in.read();
                if (c == 45) {
                    this.clearText = false;
                    this.start = true;
                    this.restart = true;
                } else {
                    c = this.in.read();
                }
                this.newLineFound = false;
            } else if (c != 10 && this.lastC != 13) {
                this.newLineFound = false;
            }
            this.lastC = c;
            if (c < 0) {
                this.isEndOfStream = true;
            }
            return c;
        }
        if (this.bufPtr > 2 || this.crcFound) {
            int c = this.readIgnoreSpace();
            if (c == 13 || c == 10) {
                c = this.readIgnoreSpace();
                while (c == 10 || c == 13) {
                    c = this.readIgnoreSpace();
                }
                if (c == 61) {
                    this.bufPtr = ArmoredInputStream.decode(this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
                    if (this.bufPtr != 0) {
                        throw new ArmoredInputException("malformed crc in armored message");
                    }
                    this.crcFound = true;
                    int i = (this.outBuf[0] & 0xFF) << 16 | (this.outBuf[1] & 0xFF) << 8 | this.outBuf[2] & 0xFF;
                    if (i != this.crc.getValue()) {
                        throw new ArmoredInputException("crc check failed in armored message");
                    }
                    return this.read();
                }
                if (c == 45) {
                    while ((c = this.in.read()) >= 0 && c != 10 && c != 13) {
                    }
                    if (!this.crcFound && this.detectMissingChecksum) {
                        throw new ArmoredInputException("crc check not found");
                    }
                    this.crcFound = false;
                    this.start = true;
                    this.bufPtr = 3;
                    if (c < 0) {
                        this.isEndOfStream = true;
                    }
                    return -1;
                }
            }
            if (c < 0) {
                this.isEndOfStream = true;
                return -1;
            }
            this.bufPtr = ArmoredInputStream.decode(c, this.readIgnoreSpace(), this.readIgnoreSpace(), this.readIgnoreSpace(), this.outBuf);
            if (this.bufPtr == 0) {
                this.crc.update3(this.outBuf, 0);
            } else {
                for (int i = this.bufPtr; i < 3; ++i) {
                    this.crc.update(this.outBuf[i] & 0xFF);
                }
            }
        }
        return this.outBuf[this.bufPtr++] & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        int i;
        this.checkIndexSize(b.length, off, len);
        if (len == 0) {
            return 0;
        }
        int c = this.read();
        if (c == -1) {
            return -1;
        }
        b[off] = (byte)c;
        for (i = 1; i < len && (c = this.read()) != -1; ++i) {
            b[off + i] = (byte)c;
        }
        return i;
    }

    private void checkIndexSize(int size, int off, int len) {
        if (off < 0 || len < 0) {
            throw new IndexOutOfBoundsException("Offset and length cannot be negative.");
        }
        if (off > size - len) {
            throw new IndexOutOfBoundsException("Invalid offset and length.");
        }
    }

    @Override
    public void close() throws IOException {
        this.in.close();
    }

    public void setDetectMissingCRC(boolean detectMissing) {
        this.detectMissingChecksum = detectMissing;
    }

    static {
        int i;
        decodingTable = new byte[128];
        for (i = 0; i < decodingTable.length; ++i) {
            ArmoredInputStream.decodingTable[i] = -1;
        }
        for (i = 65; i <= 90; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 65);
        }
        for (i = 97; i <= 122; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 97 + 26);
        }
        for (i = 48; i <= 57; ++i) {
            ArmoredInputStream.decodingTable[i] = (byte)(i - 48 + 52);
        }
        ArmoredInputStream.decodingTable[43] = 62;
        ArmoredInputStream.decodingTable[47] = 63;
    }
}

