/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import java.security.DigestInputStream;
import java.security.Key;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.Provider;
import javax.crypto.Cipher;
import javax.crypto.CipherInputStream;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.IvParameterSpec;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.BCPGInputStream;
import org.bouncycastle.bcpg.InputStreamPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.openpgp.PGPDataValidationException;
import org.bouncycastle.openpgp.PGPEncryptedData;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, InputStreamPacket inputStreamPacket) {
        super(inputStreamPacket);
        this.keyData = symmetricKeyEncSessionPacket;
    }

    @Override
    public InputStream getInputStream() {
        return this.encData.getInputStream();
    }

    public InputStream getDataStream(char[] cArray, String string) throws PGPException, NoSuchProviderException {
        return this.getDataStream(cArray, PGPUtil.getProvider(string));
    }

    public InputStream getDataStream(char[] cArray, Provider provider) throws PGPException {
        try {
            boolean bl;
            int n;
            byte[] byArray;
            Cipher cipher;
            int n2 = this.keyData.getEncAlgorithm();
            SecretKey secretKey = PGPUtil.makeKeyFromPassPhrase(n2, this.keyData.getS2K(), cArray, provider);
            byte[] byArray2 = this.keyData.getSecKeyData();
            if (byArray2 != null && byArray2.length > 0) {
                cipher = Cipher.getInstance(PGPUtil.getSymmetricCipherName(n2) + "/CFB/NoPadding", provider);
                cipher.init(2, (Key)secretKey, new IvParameterSpec(new byte[cipher.getBlockSize()]));
                byArray = cipher.doFinal(byArray2);
                n2 = byArray[0];
                secretKey = new SecretKeySpec(byArray, 1, byArray.length - 1, PGPUtil.getSymmetricCipherName(n2));
            }
            cipher = this.createStreamCipher(n2, provider);
            byArray = new byte[cipher.getBlockSize()];
            cipher.init(2, (Key)secretKey, new IvParameterSpec(byArray));
            this.encStream = new BCPGInputStream(new CipherInputStream(this.encData.getInputStream(), cipher));
            if (this.encData instanceof SymmetricEncIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                String string = PGPUtil.getDigestName(2);
                MessageDigest messageDigest = MessageDigest.getInstance(string, provider);
                this.encStream = new DigestInputStream(this.truncStream, messageDigest);
            }
            for (n = 0; n != byArray.length; ++n) {
                int n3 = this.encStream.read();
                if (n3 < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                byArray[n] = (byte)n3;
            }
            n = this.encStream.read();
            int n4 = this.encStream.read();
            if (n < 0 || n4 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean bl2 = byArray[byArray.length - 2] == (byte)n && byArray[byArray.length - 1] == (byte)n4;
            boolean bl3 = bl = n == 0 && n4 == 0;
            if (!bl2 && !bl) {
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException pGPException) {
            throw pGPException;
        }
        catch (Exception exception) {
            throw new PGPException("Exception creating cipher", exception);
        }
    }

    private Cipher createStreamCipher(int n, Provider provider) throws NoSuchAlgorithmException, NoSuchPaddingException, NoSuchProviderException, PGPException {
        String string = this.encData instanceof SymmetricEncIntegrityPacket ? "CFB" : "OpenPGPCFB";
        String string2 = PGPUtil.getSymmetricCipherName(n) + "/" + string + "/NoPadding";
        return Cipher.getInstance(string2, provider);
    }
}

