/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBESecretKeyDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;

public class BcPBESecretKeyDecryptorBuilder {
    private PGPDigestCalculatorProvider calculatorProvider;

    public BcPBESecretKeyDecryptorBuilder(PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        this.calculatorProvider = pGPDigestCalculatorProvider;
    }

    public PBESecretKeyDecryptor build(char[] cArray) {
        return new PBESecretKeyDecryptor(cArray, this.calculatorProvider){

            public byte[] recoverKeyData(int n, byte[] byArray, byte[] byArray2, byte[] byArray3, int n2, int n3) throws PGPException {
                try {
                    return BcUtil.processBufferedBlockCipher(false, BcImplProvider.createBlockCipher(n), byArray, byArray2, byArray3, n2, n3);
                }
                catch (InvalidCipherTextException invalidCipherTextException) {
                    throw new PGPException("decryption failed: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
                }
            }

            public byte[] recoverKeyData(int n, int n2, byte[] byArray, byte[] byArray2, int n3, int n4, byte[] byArray3, byte[] byArray4) throws PGPException {
                return BcAEADUtil.processAeadKeyData(false, n, n2, byArray, byArray2, n3, n4, byArray3, 0, byArray3.length, byArray4);
            }
        };
    }
}

