/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import java.security.SecureRandom;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.crypto.InvalidCipherTextException;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.operator.PBEKeyEncryptionMethodGenerator;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.openpgp.operator.bc.SHA1PGPDigestCalculator;

public class BcPBEKeyEncryptionMethodGenerator
extends PBEKeyEncryptionMethodGenerator {
    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator) {
        super(cArray, pGPDigestCalculator);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray) {
        this(cArray, new SHA1PGPDigestCalculator());
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, S2K.Argon2Params argon2Params) {
        super(cArray, argon2Params);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, PGPDigestCalculator pGPDigestCalculator, int n) {
        super(cArray, pGPDigestCalculator, n);
    }

    public BcPBEKeyEncryptionMethodGenerator(char[] cArray, int n) {
        super(cArray, new SHA1PGPDigestCalculator(), n);
    }

    public PBEKeyEncryptionMethodGenerator setSecureRandom(SecureRandom secureRandom) {
        super.setSecureRandom(secureRandom);
        return this;
    }

    protected byte[] encryptSessionInfo(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
            return BcUtil.processBufferedBlockCipher(true, blockCipher, byArray, new byte[blockCipher.getBlockSize()], byArray2, 0, byArray2.length);
        }
        catch (InvalidCipherTextException invalidCipherTextException) {
            throw new PGPException("encryption failed: " + invalidCipherTextException.getMessage(), (Exception)((Object)invalidCipherTextException));
        }
    }

    protected byte[] generateV6KEK(int n, byte[] byArray, byte[] byArray2) {
        return BcAEADUtil.generateHKDFBytes(byArray, null, byArray2, SymmetricKeyUtils.getKeyLengthInOctets(n));
    }

    protected byte[] getEskAndTag(int n, int n2, byte[] byArray, byte[] byArray2, byte[] byArray3, byte[] byArray4) throws PGPException {
        return BcAEADUtil.processAEADData(true, n, n2, byArray2, byArray3, byArray4, byArray, 0, byArray.length, "cannot encrypt session info");
    }
}

