/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.bc;

import org.bouncycastle.bcpg.AEADEncDataPacket;
import org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.bcpg.UnsupportedPacketVersionException;
import org.bouncycastle.crypto.BlockCipher;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPSessionKey;
import org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import org.bouncycastle.openpgp.operator.PGPDigestCalculatorProvider;
import org.bouncycastle.openpgp.operator.bc.BcAEADUtil;
import org.bouncycastle.openpgp.operator.bc.BcImplProvider;
import org.bouncycastle.openpgp.operator.bc.BcUtil;
import org.bouncycastle.util.Arrays;

public class BcPBEDataDecryptorFactory
extends PBEDataDecryptorFactory {
    public BcPBEDataDecryptorFactory(char[] cArray, PGPDigestCalculatorProvider pGPDigestCalculatorProvider) {
        super(cArray, pGPDigestCalculatorProvider);
    }

    public byte[] recoverSessionData(int n, byte[] byArray, byte[] byArray2) throws PGPException {
        try {
            if (byArray2 != null && byArray2.length > 0) {
                BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
                return BcUtil.processBufferedBlockCipher(false, blockCipher, byArray, new byte[blockCipher.getBlockSize()], byArray2, 0, byArray2.length);
            }
            byte[] byArray3 = new byte[byArray.length + 1];
            byArray3[0] = (byte)n;
            System.arraycopy(byArray, 0, byArray3, 1, byArray.length);
            return byArray3;
        }
        catch (Exception exception) {
            throw new PGPException("Exception recovering session info", exception);
        }
    }

    public byte[] recoverAEADEncryptedSessionData(SymmetricKeyEncSessionPacket symmetricKeyEncSessionPacket, byte[] byArray) throws PGPException {
        byte[] byArray2;
        if (symmetricKeyEncSessionPacket.getVersion() < 5) {
            throw new PGPException("SKESK packet MUST be version 5 or later.");
        }
        byte[] byArray3 = symmetricKeyEncSessionPacket.getAAData();
        if (symmetricKeyEncSessionPacket.getVersion() == 5) {
            byArray2 = byArray;
        } else if (symmetricKeyEncSessionPacket.getVersion() == 6) {
            int n = SymmetricKeyUtils.getKeyLengthInOctets(symmetricKeyEncSessionPacket.getEncAlgorithm());
            byArray2 = BcAEADUtil.generateHKDFBytes(byArray, null, byArray3, n);
        } else {
            throw new UnsupportedPacketVersionException("Unsupported SKESK packet version encountered: " + symmetricKeyEncSessionPacket.getVersion());
        }
        byte[] byArray4 = Arrays.concatenate((byte[])symmetricKeyEncSessionPacket.getSecKeyData(), (byte[])symmetricKeyEncSessionPacket.getAuthTag());
        return BcAEADUtil.processAEADData(false, symmetricKeyEncSessionPacket.getEncAlgorithm(), symmetricKeyEncSessionPacket.getAeadAlgorithm(), byArray2, symmetricKeyEncSessionPacket.getIv(), symmetricKeyEncSessionPacket.getAAData(), byArray4, 0, byArray4.length, "Exception recovering session info");
    }

    public PGPDataDecryptor createDataDecryptor(boolean bl, int n, byte[] byArray) throws PGPException {
        BlockCipher blockCipher = BcImplProvider.createBlockCipher(n);
        return BcUtil.createDataDecryptor(bl, blockCipher, byArray);
    }

    public PGPDataDecryptor createDataDecryptor(AEADEncDataPacket aEADEncDataPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV5DataDecryptor(aEADEncDataPacket, pGPSessionKey);
    }

    public PGPDataDecryptor createDataDecryptor(SymmetricEncIntegrityPacket symmetricEncIntegrityPacket, PGPSessionKey pGPSessionKey) throws PGPException {
        return BcAEADUtil.createOpenPgpV6DataDecryptor(symmetricEncIntegrityPacket, pGPSessionKey);
    }
}

