/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.io.OutputStream;
import java.security.InvalidKeyException;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Signature;
import java.security.SignatureException;
import java.security.interfaces.RSAPublicKey;
import org.bouncycastle.jcajce.io.OutputStreamFactory;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPPublicKey;
import org.bouncycastle.openpgp.PGPRuntimeOperationException;
import org.bouncycastle.openpgp.operator.PGPContentVerifier;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilder;
import org.bouncycastle.openpgp.operator.PGPContentVerifierBuilderProvider;
import org.bouncycastle.openpgp.operator.PGPDigestCalculator;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPDigestCalculatorProviderBuilder;
import org.bouncycastle.openpgp.operator.jcajce.JcaPGPKeyConverter;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;

public class JcaPGPContentVerifierBuilderProvider
implements PGPContentVerifierBuilderProvider {
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JcaPGPDigestCalculatorProviderBuilder digestCalculatorProviderBuilder = new JcaPGPDigestCalculatorProviderBuilder();
    private JcaPGPKeyConverter keyConverter = new JcaPGPKeyConverter();

    public JcaPGPContentVerifierBuilderProvider setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.keyConverter.setProvider(provider);
        this.digestCalculatorProviderBuilder.setProvider(provider);
        return this;
    }

    public JcaPGPContentVerifierBuilderProvider setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.keyConverter.setProvider(string);
        this.digestCalculatorProviderBuilder.setProvider(string);
        return this;
    }

    public PGPContentVerifierBuilder get(int n, int n2) throws PGPException {
        return new JcaPGPContentVerifierBuilder(n, n2);
    }

    private class JcaPGPContentVerifierBuilder
    implements PGPContentVerifierBuilder {
        private int hashAlgorithm;
        private int keyAlgorithm;

        public JcaPGPContentVerifierBuilder(int n, int n2) {
            this.keyAlgorithm = n;
            this.hashAlgorithm = n2;
        }

        public PGPContentVerifier build(PGPPublicKey pGPPublicKey) throws PGPException {
            PGPDigestCalculator pGPDigestCalculator = JcaPGPContentVerifierBuilderProvider.this.digestCalculatorProviderBuilder.build().get(this.hashAlgorithm);
            PublicKey publicKey = JcaPGPContentVerifierBuilderProvider.this.keyConverter.getPublicKey(pGPPublicKey);
            Signature signature = this.keyAlgorithm == 22 && publicKey.getAlgorithm().equals("Ed448") ? JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(28, this.hashAlgorithm) : JcaPGPContentVerifierBuilderProvider.this.helper.createSignature(this.keyAlgorithm, this.hashAlgorithm);
            try {
                signature.initVerify(publicKey);
            }
            catch (InvalidKeyException invalidKeyException) {
                throw new PGPException("invalid key.", invalidKeyException);
            }
            return new PGPContentVerifier(this, pGPPublicKey, publicKey, signature, pGPDigestCalculator){
                private final boolean isEdDsa;
                private final /* synthetic */ PGPPublicKey val$publicKey;
                private final /* synthetic */ PublicKey val$jcaKey;
                private final /* synthetic */ Signature val$signature;
                private final /* synthetic */ PGPDigestCalculator val$digestCalculator;
                private final /* synthetic */ JcaPGPContentVerifierBuilder this$1;
                {
                    this.this$1 = jcaPGPContentVerifierBuilder;
                    this.val$publicKey = pGPPublicKey;
                    this.val$jcaKey = publicKey;
                    this.val$signature = signature;
                    this.val$digestCalculator = pGPDigestCalculator;
                    this.isEdDsa = JcaPGPContentVerifierBuilder.access$300(this.this$1) == 22 || JcaPGPContentVerifierBuilder.access$300(this.this$1) == 28 || JcaPGPContentVerifierBuilder.access$300(this.this$1) == 27;
                }

                public int getHashAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$400(this.this$1);
                }

                public int getKeyAlgorithm() {
                    return JcaPGPContentVerifierBuilder.access$300(this.this$1);
                }

                public long getKeyID() {
                    return this.val$publicKey.getKeyID();
                }

                public boolean verify(byte[] byArray) {
                    try {
                        int n;
                        if (this.val$jcaKey instanceof RSAPublicKey && byArray.length < (n = (((RSAPublicKey)this.val$jcaKey).getModulus().bitLength() + 7) / 8)) {
                            byte[] byArray2 = new byte[n];
                            System.arraycopy(byArray, 0, byArray2, byArray2.length - byArray.length, byArray.length);
                            return this.val$signature.verify(byArray2);
                        }
                        if (this.isEdDsa) {
                            this.val$signature.update(this.val$digestCalculator.getDigest());
                            return this.val$signature.verify(byArray);
                        }
                        return this.val$signature.verify(byArray);
                    }
                    catch (SignatureException signatureException) {
                        throw new PGPRuntimeOperationException("unable to verify signature: " + signatureException.getMessage(), signatureException);
                    }
                }

                public OutputStream getOutputStream() {
                    if (this.isEdDsa) {
                        return this.val$digestCalculator.getOutputStream();
                    }
                    return OutputStreamFactory.createStream((Signature)this.val$signature);
                }
            };
        }

        static /* synthetic */ int access$300(JcaPGPContentVerifierBuilder jcaPGPContentVerifierBuilder) {
            return jcaPGPContentVerifierBuilder.keyAlgorithm;
        }

        static /* synthetic */ int access$400(JcaPGPContentVerifierBuilder jcaPGPContentVerifierBuilder) {
            return jcaPGPContentVerifierBuilder.hashAlgorithm;
        }
    }
}

