/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.openpgp.operator.jcajce;

import java.security.Provider;
import java.security.SecureRandom;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.bouncycastle.bcpg.AEADUtils;
import org.bouncycastle.bcpg.PublicKeyPacket;
import org.bouncycastle.bcpg.S2K;
import org.bouncycastle.bcpg.SymmetricKeyUtils;
import org.bouncycastle.crypto.DerivationParameters;
import org.bouncycastle.crypto.Digest;
import org.bouncycastle.crypto.digests.SHA256Digest;
import org.bouncycastle.crypto.generators.HKDFBytesGenerator;
import org.bouncycastle.crypto.params.HKDFParameters;
import org.bouncycastle.jcajce.util.DefaultJcaJceHelper;
import org.bouncycastle.jcajce.util.JcaJceHelper;
import org.bouncycastle.jcajce.util.NamedJcaJceHelper;
import org.bouncycastle.jcajce.util.ProviderJcaJceHelper;
import org.bouncycastle.openpgp.PGPException;
import org.bouncycastle.openpgp.PGPUtil;
import org.bouncycastle.openpgp.operator.PBESecretKeyEncryptor;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADCipherUtil;
import org.bouncycastle.openpgp.operator.jcajce.JceAEADUtil;
import org.bouncycastle.openpgp.operator.jcajce.OperatorHelper;
import org.bouncycastle.util.Arrays;

public class JcaAEADSecretKeyEncryptorBuilder {
    private int aeadAlgorithm;
    private int symmetricAlgorithm;
    private S2K.Argon2Params argon2Params;
    private OperatorHelper helper = new OperatorHelper((JcaJceHelper)new DefaultJcaJceHelper());
    private JceAEADUtil aeadUtil = new JceAEADUtil(this.helper);

    public JcaAEADSecretKeyEncryptorBuilder(int n, int n2, S2K.Argon2Params argon2Params) {
        this.aeadAlgorithm = n;
        this.symmetricAlgorithm = n2;
        this.argon2Params = argon2Params;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(Provider provider) {
        this.helper = new OperatorHelper((JcaJceHelper)new ProviderJcaJceHelper(provider));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public JcaAEADSecretKeyEncryptorBuilder setProvider(String string) {
        this.helper = new OperatorHelper((JcaJceHelper)new NamedJcaJceHelper(string));
        this.aeadUtil = new JceAEADUtil(this.helper);
        return this;
    }

    public PBESecretKeyEncryptor build(char[] cArray, final PublicKeyPacket publicKeyPacket) {
        return new PBESecretKeyEncryptor(this.symmetricAlgorithm, this.aeadAlgorithm, this.argon2Params, new SecureRandom(), cArray){
            private byte[] iv;
            {
                super(n, n2, argon2Params, secureRandom, cArray);
                this.iv = new byte[AEADUtils.getIVLength(this.aeadAlgorithm)];
                this.random.nextBytes(this.iv);
            }

            public byte[] encryptKeyData(byte[] byArray, byte[] byArray2, int n, int n2) throws PGPException {
                int n3 = publicKeyPacket.getPacketTag() == 6 ? 5 : 7;
                byte[] byArray3 = new byte[]{(byte)(0xC0 | n3), (byte)publicKeyPacket.getVersion(), (byte)JcaAEADSecretKeyEncryptorBuilder.this.symmetricAlgorithm, (byte)this.aeadAlgorithm};
                HKDFParameters hKDFParameters = new HKDFParameters(this.getKey(), null, byArray3);
                HKDFBytesGenerator hKDFBytesGenerator = new HKDFBytesGenerator((Digest)new SHA256Digest());
                hKDFBytesGenerator.init((DerivationParameters)hKDFParameters);
                byArray = new byte[SymmetricKeyUtils.getKeyLengthInOctets(this.encAlgorithm)];
                hKDFBytesGenerator.generateBytes(byArray, 0, byArray.length);
                try {
                    byte[] byArray4 = Arrays.prepend((byte[])publicKeyPacket.getEncodedContents(), (byte)((byte)(0xC0 | n3)));
                    SecretKeySpec secretKeySpec = new SecretKeySpec(byArray, PGPUtil.getSymmetricCipherName(this.encAlgorithm));
                    Cipher cipher = JcaAEADSecretKeyEncryptorBuilder.this.aeadUtil.createAEADCipher(this.encAlgorithm, this.aeadAlgorithm);
                    JceAEADCipherUtil.setUpAeadCipher(cipher, secretKeySpec, 1, this.iv, 128, byArray4);
                    byte[] byArray5 = cipher.doFinal(byArray2, n, n2);
                    return byArray5;
                }
                catch (Exception exception) {
                    throw new PGPException("Exception AEAD protecting private key material", exception);
                }
            }

            public byte[] getCipherIV() {
                return this.iv;
            }
        };
    }
}

